/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks.builder;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.buildspec.tasks.builder.ConfigurationBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "limitCPU", "limitMemory", "nodeSelector", "operatorNamespace", "orderStrategy", "platforms", "requestCPU", "requestMemory", "strategy", "toolImage"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Configuration
implements Editable<ConfigurationBuilder>,
KubernetesResource {
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="Annotation to use for the builder pod. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="limitCPU")
    @JsonPropertyDescription(value="The maximum amount of CPU required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitCPU;
    @JsonProperty(value="limitMemory")
    @JsonPropertyDescription(value="The maximum amount of memory required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitMemory;
    @JsonProperty(value="nodeSelector")
    @JsonPropertyDescription(value="The node selector for the builder pod. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> nodeSelector;
    @JsonProperty(value="operatorNamespace")
    @JsonPropertyDescription(value="The namespace where to run the builder Pod (must be the same of the operator in charge of this Build reconciliation).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String operatorNamespace;
    @JsonProperty(value="orderStrategy")
    @JsonPropertyDescription(value="the build order strategy to adopt")
    @JsonSetter(nulls=Nulls.SKIP)
    private OrderStrategy orderStrategy;
    @JsonProperty(value="platforms")
    @JsonPropertyDescription(value="The list of platforms used in order to build a container image.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> platforms;
    @JsonProperty(value="requestCPU")
    @JsonPropertyDescription(value="The minimum amount of CPU required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestCPU;
    @JsonProperty(value="requestMemory")
    @JsonPropertyDescription(value="The minimum amount of memory required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestMemory;
    @JsonProperty(value="strategy")
    @JsonPropertyDescription(value="the strategy to adopt")
    @JsonSetter(nulls=Nulls.SKIP)
    private Strategy strategy;
    @JsonProperty(value="toolImage")
    @JsonPropertyDescription(value="The container image to be used to run the build.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String toolImage;

    public ConfigurationBuilder edit() {
        return new ConfigurationBuilder(this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public void setLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public void setLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public String getOperatorNamespace() {
        return this.operatorNamespace;
    }

    public void setOperatorNamespace(String operatorNamespace) {
        this.operatorNamespace = operatorNamespace;
    }

    public OrderStrategy getOrderStrategy() {
        return this.orderStrategy;
    }

    public void setOrderStrategy(OrderStrategy orderStrategy) {
        this.orderStrategy = orderStrategy;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public void setRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public void setRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public String getToolImage() {
        return this.toolImage;
    }

    public void setToolImage(String toolImage) {
        this.toolImage = toolImage;
    }

    public String toString() {
        return "Configuration(annotations=" + this.getAnnotations() + ", limitCPU=" + this.getLimitCPU() + ", limitMemory=" + this.getLimitMemory() + ", nodeSelector=" + this.getNodeSelector() + ", operatorNamespace=" + this.getOperatorNamespace() + ", orderStrategy=" + this.getOrderStrategy() + ", platforms=" + this.getPlatforms() + ", requestCPU=" + this.getRequestCPU() + ", requestMemory=" + this.getRequestMemory() + ", strategy=" + this.getStrategy() + ", toolImage=" + this.getToolImage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$limitCPU = this.getLimitCPU();
        String other$limitCPU = other.getLimitCPU();
        if (this$limitCPU == null ? other$limitCPU != null : !this$limitCPU.equals(other$limitCPU)) {
            return false;
        }
        String this$limitMemory = this.getLimitMemory();
        String other$limitMemory = other.getLimitMemory();
        if (this$limitMemory == null ? other$limitMemory != null : !this$limitMemory.equals(other$limitMemory)) {
            return false;
        }
        Map<String, String> this$nodeSelector = this.getNodeSelector();
        Map<String, String> other$nodeSelector = other.getNodeSelector();
        if (this$nodeSelector == null ? other$nodeSelector != null : !((Object)this$nodeSelector).equals(other$nodeSelector)) {
            return false;
        }
        String this$operatorNamespace = this.getOperatorNamespace();
        String other$operatorNamespace = other.getOperatorNamespace();
        if (this$operatorNamespace == null ? other$operatorNamespace != null : !this$operatorNamespace.equals(other$operatorNamespace)) {
            return false;
        }
        OrderStrategy this$orderStrategy = this.getOrderStrategy();
        OrderStrategy other$orderStrategy = other.getOrderStrategy();
        if (this$orderStrategy == null ? other$orderStrategy != null : !((Object)((Object)this$orderStrategy)).equals((Object)other$orderStrategy)) {
            return false;
        }
        List<String> this$platforms = this.getPlatforms();
        List<String> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        String this$requestCPU = this.getRequestCPU();
        String other$requestCPU = other.getRequestCPU();
        if (this$requestCPU == null ? other$requestCPU != null : !this$requestCPU.equals(other$requestCPU)) {
            return false;
        }
        String this$requestMemory = this.getRequestMemory();
        String other$requestMemory = other.getRequestMemory();
        if (this$requestMemory == null ? other$requestMemory != null : !this$requestMemory.equals(other$requestMemory)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        String this$toolImage = this.getToolImage();
        String other$toolImage = other.getToolImage();
        return !(this$toolImage == null ? other$toolImage != null : !this$toolImage.equals(other$toolImage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $limitCPU = this.getLimitCPU();
        result = result * 59 + ($limitCPU == null ? 43 : $limitCPU.hashCode());
        String $limitMemory = this.getLimitMemory();
        result = result * 59 + ($limitMemory == null ? 43 : $limitMemory.hashCode());
        Map<String, String> $nodeSelector = this.getNodeSelector();
        result = result * 59 + ($nodeSelector == null ? 43 : ((Object)$nodeSelector).hashCode());
        String $operatorNamespace = this.getOperatorNamespace();
        result = result * 59 + ($operatorNamespace == null ? 43 : $operatorNamespace.hashCode());
        OrderStrategy $orderStrategy = this.getOrderStrategy();
        result = result * 59 + ($orderStrategy == null ? 43 : ((Object)((Object)$orderStrategy)).hashCode());
        List<String> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        String $requestCPU = this.getRequestCPU();
        result = result * 59 + ($requestCPU == null ? 43 : $requestCPU.hashCode());
        String $requestMemory = this.getRequestMemory();
        result = result * 59 + ($requestMemory == null ? 43 : $requestMemory.hashCode());
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        String $toolImage = this.getToolImage();
        result = result * 59 + ($toolImage == null ? 43 : $toolImage.hashCode());
        return result;
    }

    public static enum OrderStrategy {
        DEPENDENCIES("dependencies"),
        FIFO("fifo"),
        SEQUENTIAL("sequential");

        String value;

        private OrderStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum Strategy {
        ROUTINE("routine"),
        POD("pod");

        String value;

        private Strategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

