/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.text;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.core._CoreAPI;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.MapKeyValuePairIterator;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx2;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorBase;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.ThreadLocalStack;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateProcessor {
    private static final Logger log = LoggerFactory.getLogger(TemplateProcessor.class);
    static BrooklynFreemarkerUnwrappableObjectWrapper BROOKLYN_WRAPPER;
    static ThreadLocalStack<Map<TemplateModel, Object>> TEMPLATE_MODEL_UNWRAP_CACHE;
    static ThreadLocalStack<String> TEMPLATE_FILE_WANTING_LEGACY_SYNTAX;
    static ThreadLocalStack<Boolean> IS_FOR_WORKFLOW;
    InterpolationErrorMode interpolationErrorMode;

    public static TemplateModel wrapAsTemplateModel(Object o) throws TemplateModelException {
        return BROOKLYN_WRAPPER.wrap(o);
    }

    public static Maybe<Object> unwrapTemplateModelMaybe(TemplateModel templateModel) {
        return BROOKLYN_WRAPPER.unwrapMaybe(templateModel);
    }

    public static void openLocalTemplateModelCache() {
        TEMPLATE_MODEL_UNWRAP_CACHE.push((Object)MutableMap.of());
    }

    public static void closeLocalTemplateModelCache() {
        TEMPLATE_MODEL_UNWRAP_CACHE.pop();
    }

    public static String processTemplateFile(String templateFileName, Map<String, ? extends Object> substitutions) {
        String templateContents;
        try {
            templateContents = Files.toString((File)new File(templateFileName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Error loading file " + templateFileName, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        return TemplateProcessor.processTemplateContents(templateFileName, templateContents, substitutions);
    }

    public static String processTemplateFile(String templateFileName, EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
        String templateContents;
        try {
            templateContents = Files.toString((File)new File(templateFileName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Error loading file " + templateFileName, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        return TemplateProcessor.processTemplateContents(templateFileName, templateContents, driver, extraSubstitutions);
    }

    public static String processTemplateContents(String templateContents, EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents("unknown", templateContents, EntityAndMapTemplateModel.forDriver(driver, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, ManagementContext managementContext, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents("unknown", templateContents, EntityAndMapTemplateModel.forManagementContext(managementContext, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, Location location, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents("unknown", templateContents, LocationAndMapTemplateModel.forLocation((LocationInternal)location, extraSubstitutions));
    }

    public static String processTemplateContents(String context, String templateContents, EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(context, templateContents, EntityAndMapTemplateModel.forDriver(driver, extraSubstitutions));
    }

    public static String processTemplateContents(String context, String templateContents, ManagementContext managementContext, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(context, templateContents, EntityAndMapTemplateModel.forManagementContext(managementContext, extraSubstitutions));
    }

    public static String processTemplateContents(String context, String templateContents, Location location, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(context, templateContents, LocationAndMapTemplateModel.forLocation((LocationInternal)location, extraSubstitutions));
    }

    @Beta
    public static Error handleModelError(String msg, Throwable cause) throws TemplateModelException {
        if (Exceptions.isCausedByInterruptInAnyThread((Throwable)cause)) {
            throw new TemplateModelDataUnavailableException(msg + ": " + Exceptions.collapseText((Throwable)cause), cause);
        }
        Exceptions.propagateIfFatal((Throwable)cause);
        throw new TemplateModelException(msg + ": " + Exceptions.collapseText((Throwable)cause), cause);
    }

    private static TemplateHashModel dotOrNull(Map<String, ?> extraSubstitutions) {
        if (extraSubstitutions == null) {
            return null;
        }
        return new DotSplittingTemplateModel(extraSubstitutions);
    }

    private static TemplateHashModel wrappedBeanToHashOrNull(Object o) {
        if (o == null) {
            return null;
        }
        TemplateModel wrapped = null;
        try {
            wrapped = BROOKLYN_WRAPPER.wrapAsBean(o);
        }
        catch (TemplateModelException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (wrapped instanceof TemplateHashModel) {
            return (TemplateHashModel)wrapped;
        }
        return null;
    }

    public static String processTemplateContents(String templateContents, EntityInternal entity, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents("unknown", templateContents, entity, extraSubstitutions);
    }

    public static String processTemplateContents(String context, String templateContents, EntityInternal entity, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(context, templateContents, EntityAndMapTemplateModel.forEntity((Entity)entity, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, Map<String, ? extends Object> substitutions) {
        return TemplateProcessor.processTemplateContents("unknown", templateContents, substitutions);
    }

    public static String processTemplateContents(String context, String templateContents, Map<String, ? extends Object> substitutions) {
        TemplateHashModel root;
        try {
            root = substitutions != null ? (TemplateHashModel)TemplateProcessor.wrapAsTemplateModel(substitutions) : null;
        }
        catch (TemplateModelException e) {
            throw new IllegalStateException("Unable to set up TemplateHashModel to parse template, given " + substitutions + ": " + (Object)((Object)e), e);
        }
        return TemplateProcessor.processTemplateContents(context, templateContents, root);
    }

    public static String processTemplateContents(String templateContents, TemplateHashModel substitutions) {
        return TemplateProcessor.processTemplateContents("unknown", templateContents, substitutions);
    }

    private static String processTemplateContents(String context, String templateContents, TemplateHashModel substitutions) {
        return (String)TemplateProcessor.processTemplateContentsLegacy(context, templateContents, substitutions, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static Object processTemplateContentsLegacy(String context, String templateContents, TemplateHashModel substitutions, boolean allowSingleVariableObject, boolean logErrors) {
        try {
            TEMPLATE_FILE_WANTING_LEGACY_SYNTAX.push((Object)context);
            Object object = TemplateProcessor.processTemplateContents(context, templateContents, substitutions, allowSingleVariableObject, logErrors);
            return object;
        }
        finally {
            TEMPLATE_FILE_WANTING_LEGACY_SYNTAX.pop();
        }
    }

    public static Object processTemplateContents(String context, String templateContents, TemplateHashModel substitutions, boolean allowSingleVariableObject, boolean logErrors) {
        return TemplateProcessor.processTemplateContents(context, templateContents, substitutions, allowSingleVariableObject, logErrors, InterpolationErrorMode.FAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object processTemplateContents(String context, String templateContents, TemplateHashModel substitutions, boolean allowSingleVariableObject, boolean logErrors, InterpolationErrorMode errorMode) {
        try {
            Template template;
            block12: {
                Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
                cfg.setLogTemplateExceptions(logErrors);
                cfg.setNumberFormat("computer");
                StringTemplateLoader templateLoader = new StringTemplateLoader();
                templateLoader.putTemplate(context, templateContents);
                cfg.setTemplateLoader((TemplateLoader)templateLoader);
                template = cfg.getTemplate(context);
                if (allowSingleVariableObject && template.getRootTreeNode().getClass().getName().equals("freemarker.core.DollarVariable")) {
                    TemplateElement dollarVariable = template.getRootTreeNode();
                    Maybe escapedExpression = Reflections.getFieldValueMaybe((Object)dollarVariable, (String)"escapedExpression");
                    Environment env = template.createProcessingEnvironment((Object)substitutions, null);
                    Maybe evalMethod = Reflections.findMethodMaybe(Expression.class, (String)"eval", (Class[])new Class[]{Environment.class});
                    try {
                        Maybe model;
                        TemplateProcessor.openLocalTemplateModelCache();
                        Maybe maybe = model = evalMethod.isAbsent() ? Maybe.Absent.castAbsent((Maybe)evalMethod) : escapedExpression.map(expr -> {
                            try {
                                return Reflections.invokeMethodFromArgs((Object)expr, (Method)((Method)evalMethod.get()), (List)MutableList.of((Object)env), (boolean)true);
                            }
                            catch (Exception e) {
                                Exceptions.propagateIfFatal((Throwable)e);
                                TemplateException te = (TemplateException)Exceptions.getFirstThrowableOfType((Throwable)e, TemplateException.class);
                                if (te != null) {
                                    try {
                                        return new ForgivingFreemarkerTemplateExceptionHandler(errorMode).handleSingleVariableExpressionTemplate(te, templateContents);
                                    }
                                    catch (TemplateException ex) {
                                        throw Exceptions.propagate((Throwable)ex);
                                    }
                                }
                                throw Exceptions.propagate((Throwable)e);
                            }
                        });
                        if (model.isPresent()) {
                            if (model.get() instanceof TemplateModel) {
                                Object object = TemplateProcessor.unwrapTemplateModelMaybe((TemplateModel)model.get()).get();
                                return object;
                            }
                            if (model.get() != null) {
                                log.warn("Unable to find model in local cache for unwrapping: " + model.get());
                            }
                            break block12;
                        }
                        log.warn("Unable to access FreeMarker internals to resolve " + templateContents + "; will cast argument as string");
                    }
                    finally {
                        TemplateProcessor.closeLocalTemplateModelCache();
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(baos);
            template.setTemplateExceptionHandler((TemplateExceptionHandler)new ForgivingFreemarkerTemplateExceptionHandler(errorMode));
            template.process((Object)substitutions, (Writer)out);
            ((Writer)out).flush();
            return new String(baos.toByteArray());
        }
        catch (Exception e) {
            if (!logErrors) throw Exceptions.propagate((Throwable)e);
            if (e instanceof RuntimeInterruptedException) {
                log.warn("Template not currently resolvable: " + Exceptions.collapseText((Throwable)e));
            } else {
                log.warn("Error processing template (propagating): " + Exceptions.collapseText((Throwable)e), (Throwable)e);
            }
            log.debug("Template which could not be parsed (causing " + e + ") is:" + (Strings.isMultiLine((String)templateContents) ? "\n" + templateContents : templateContents));
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object processTemplateContentsForWorkflow(String context, String templateContents, TemplateHashModel substitutions, boolean allowSingleVariableObject, boolean logErrors, InterpolationErrorMode errorMode) {
        try {
            IS_FOR_WORKFLOW.push((Object)true);
            Object object = TemplateProcessor.processTemplateContents(context, templateContents, substitutions, allowSingleVariableObject, logErrors, errorMode);
            return object;
        }
        finally {
            IS_FOR_WORKFLOW.pop();
        }
    }

    public void setInterpolationErrorMode(InterpolationErrorMode interpolationErrorMode) {
        this.interpolationErrorMode = interpolationErrorMode;
    }

    static {
        if (System.getProperty("org.freemarker.loggerLibrary") == null) {
            System.setProperty("org.freemarker.loggerLibrary", "SLF4J");
        }
        BROOKLYN_WRAPPER = new BrooklynFreemarkerUnwrappableObjectWrapper();
        TEMPLATE_MODEL_UNWRAP_CACHE = new ThreadLocalStack(true);
        TEMPLATE_FILE_WANTING_LEGACY_SYNTAX = new ThreadLocalStack(true);
        IS_FOR_WORKFLOW = new ThreadLocalStack(true);
    }

    public static class ForgivingFreemarkerTemplateExceptionHandler
    implements TemplateExceptionHandler {
        private final InterpolationErrorMode errorMode;

        public ForgivingFreemarkerTemplateExceptionHandler(InterpolationErrorMode errorMode) {
            this.errorMode = errorMode;
        }

        public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
            if (this.errorMode == null || this.errorMode == InterpolationErrorMode.FAIL) {
                throw te;
            }
            if (this.errorMode == InterpolationErrorMode.BLANK) {
                return;
            }
            if (this.errorMode == InterpolationErrorMode.IGNORE) {
                try {
                    TemplateElement[] instructions = _CoreAPI.getInstructionStackSnapshot((Environment)env);
                    if (instructions.length > 0) {
                        out.write(instructions[instructions.length - 1].getCanonicalForm());
                        return;
                    }
                    throw Exceptions.propagateAnnotated((String)"Unable to retrieve instruction so cannot ignore error in processing it", (Throwable)te);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }

        public TemplateModel handleSingleVariableExpressionTemplate(TemplateException te, String templateText) throws TemplateException {
            if (this.errorMode == InterpolationErrorMode.BLANK) {
                return new SimpleScalar("");
            }
            if (this.errorMode == InterpolationErrorMode.IGNORE) {
                return new SimpleScalar(templateText);
            }
            throw te;
        }
    }

    public static enum InterpolationErrorMode {
        FAIL,
        BLANK,
        IGNORE;

    }

    protected static final class LocationAndMapTemplateModel
    implements TemplateHashModel,
    UnwrappableTemplateModel {
        protected final LocationInternal location;
        protected final ManagementContext mgmt;
        protected final DotSplittingTemplateModel extraSubstitutionsModel;

        @Deprecated
        protected LocationAndMapTemplateModel(LocationInternal location, Map<String, ? extends Object> extraSubstitutions) {
            this.location = (LocationInternal)Preconditions.checkNotNull((Object)location, (Object)"location");
            this.mgmt = location.getManagementContext();
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of((Object)this.location);
        }

        static TemplateHashModel forLocation(LocationInternal location, Map<String, ? extends Object> extraSubstitutions) {
            return new FirstAvailableTemplateModel(new LocationAndMapTemplateModel(location, null), TemplateProcessor.wrappedBeanToHashOrNull(location), TemplateProcessor.dotOrNull(extraSubstitutions));
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object result;
            if (this.extraSubstitutionsModel.contains(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.extraSubstitutionsModel.get(key));
            }
            if ("location".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.location);
            }
            if ("config".equals(key)) {
                return new LocationConfigTemplateModel(this.location);
            }
            if ("mgmt".equals(key)) {
                return new MgmtConfigTemplateModel(this.mgmt);
            }
            if (this.mgmt != null && (result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build())) != null) {
                log.warn("Deprecated access of global brooklyn.properties value for " + key + "; should be qualified with 'mgmt.'");
                return TemplateProcessor.wrapAsTemplateModel(result);
            }
            if ("name".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.location.getDisplayName());
            }
            if ("javaSysProps".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(System.getProperties());
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.location + "]";
        }
    }

    public static final class EntityAndMapTemplateModel
    implements TemplateHashModel,
    UnwrappableTemplateModel {
        protected final EntityInternal entity;
        protected final EntityDriver driver;
        protected final ManagementContext mgmt;
        protected final DotSplittingTemplateModel extraSubstitutionsModel;
        protected boolean isForWorkflow = false;

        protected EntityAndMapTemplateModel(ManagementContext mgmt, EntityInternal entity, EntityDriver driver) {
            this.driver = driver;
            EntityInternal entityInternal = entity != null ? entity : (this.entity = driver != null ? (EntityInternal)driver.getEntity() : null);
            this.mgmt = mgmt != null ? mgmt : (this.entity != null ? this.entity.getManagementContext() : null);
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(null);
        }

        public EntityAndMapTemplateModel setIsForWorkflow(boolean isForWorkflow) {
            this.isForWorkflow = isForWorkflow;
            return this;
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.ofDisallowingNull((Object)(this.entity != null ? this.entity : (this.mgmt != null ? this.mgmt : this.extraSubstitutionsModel.unwrap().orNull())));
        }

        public static TemplateHashModel forDriver(EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
            return new FirstAvailableTemplateModel(new EntityAndMapTemplateModel(null, null, driver), TemplateProcessor.wrappedBeanToHashOrNull(driver), TemplateProcessor.wrappedBeanToHashOrNull(driver.getEntity()), TemplateProcessor.dotOrNull(extraSubstitutions));
        }

        public static TemplateHashModel forEntity(Entity entity, Map<String, ? extends Object> extraSubstitutions) {
            EntityAndMapTemplateModel entityModel = new EntityAndMapTemplateModel(null, (EntityInternal)entity, null);
            if (Boolean.TRUE.equals(IS_FOR_WORKFLOW.peek().orNull())) {
                entityModel.setIsForWorkflow(true);
            }
            return new FirstAvailableTemplateModel(entityModel, TemplateProcessor.wrappedBeanToHashOrNull(entity), TemplateProcessor.dotOrNull(extraSubstitutions));
        }

        public static TemplateHashModel forEntityPossiblyInWorkflow(Entity entity, Map<String, ? extends Object> extraSubstitutions, boolean isInWorkflow) {
            return new FirstAvailableTemplateModel(new EntityAndMapTemplateModel(null, (EntityInternal)entity, null).setIsForWorkflow(isInWorkflow), TemplateProcessor.wrappedBeanToHashOrNull(entity), TemplateProcessor.dotOrNull(extraSubstitutions));
        }

        public static TemplateHashModel forManagementContext(ManagementContext mgmt, Map<String, ? extends Object> extraSubstitutions) {
            return new FirstAvailableTemplateModel(new EntityAndMapTemplateModel(mgmt, null, null), TemplateProcessor.dotOrNull(extraSubstitutions));
        }

        @Deprecated
        protected EntityAndMapTemplateModel(ManagementContext mgmt, Map<String, ? extends Object> extraSubstitutions) {
            this.entity = null;
            this.driver = null;
            this.mgmt = mgmt;
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        @Deprecated
        protected EntityAndMapTemplateModel(EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
            this.driver = driver;
            this.entity = (EntityInternal)driver.getEntity();
            this.mgmt = this.entity.getManagementContext();
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        @Deprecated
        protected EntityAndMapTemplateModel(EntityInternal entity, Map<String, ? extends Object> extraSubstitutions) {
            this.entity = entity;
            this.driver = null;
            this.mgmt = entity.getManagementContext();
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if (this.extraSubstitutionsModel.contains(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.extraSubstitutionsModel.get(key));
            }
            if ("entity".equals(key) && this.entity != null) {
                return TemplateProcessor.wrapAsTemplateModel(this.entity);
            }
            if ("config".equals(key)) {
                if (this.entity != null) {
                    return new EntityConfigTemplateModel(this.entity);
                }
                return new MgmtConfigTemplateModel(this.mgmt);
            }
            if ("mgmt".equals(key)) {
                return new MgmtConfigTemplateModel(this.mgmt);
            }
            if ("driver".equals(key) && this.driver != null) {
                return TemplateProcessor.wrapAsTemplateModel(this.driver);
            }
            if ("location".equals(key)) {
                if (this.driver != null && this.driver.getLocation() != null) {
                    return TemplateProcessor.wrapAsTemplateModel(this.driver.getLocation());
                }
                if (this.entity != null) {
                    return TemplateProcessor.wrapAsTemplateModel(Iterables.getOnlyElement((Iterable)this.entity.getLocations()));
                }
            }
            if ("children".equals(key) && this.entity != null) {
                return TemplateProcessor.wrapAsTemplateModel(this.entity.getChildren());
            }
            if ("members".equals(key) && this.entity != null) {
                return TemplateProcessor.wrapAsTemplateModel(this.entity instanceof Group ? ((Group)this.entity).getMembers() : MutableList.of());
            }
            if ("sensor".equals(key)) {
                return new EntityAttributeTemplateModel(this.entity, EntityAttributeTemplateModel.SensorResolutionMode.ATTRIBUTE_VALUE);
            }
            if ("attribute".equals(key)) {
                return new EntityAttributeTemplateModel(this.entity, EntityAttributeTemplateModel.SensorResolutionMode.ATTRIBUTE_VALUE);
            }
            if ("attributeWhenReady".equals(key)) {
                return new EntityAttributeTemplateModel(this.entity, this.isForWorkflow ? EntityAttributeTemplateModel.SensorResolutionMode.ATTRIBUTE_WHEN_READY_FOR_WORKFLOW : EntityAttributeTemplateModel.SensorResolutionMode.ATTRIBUTE_WHEN_READY_FOR_TEMPLATES);
            }
            if ("sensor_definition".equals(key)) {
                return new EntityAttributeTemplateModel(this.entity, EntityAttributeTemplateModel.SensorResolutionMode.SENSOR_DEFINITION);
            }
            if ("effector".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(Maps.transformValues(this.entity.getMutableEntityType().getEffectors(), EffectorBase::of));
            }
            if ("name".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.entity.getDisplayName());
            }
            if ("tags".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.entity.tags().getTags());
            }
            if ("javaSysProps".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(System.getProperties());
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + (this.entity != null ? this.entity : this.mgmt) + "]";
        }
    }

    protected static final class EntityAttributeTemplateModel
    implements TemplateHashModel,
    UnwrappableTemplateModel {
        protected final EntityInternal entity;
        private final SensorResolutionMode mode;

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of((Object)this.entity);
        }

        protected EntityAttributeTemplateModel(EntityInternal entity, SensorResolutionMode mode) {
            this.entity = entity;
            if (TEMPLATE_FILE_WANTING_LEGACY_SYNTAX.peek().isPresentAndNonNull() && mode != SensorResolutionMode.ATTRIBUTE_WHEN_READY_FOR_TEMPLATES) {
                log.warn("Using deprecated legacy attributeWhenReady behaviour of ${entity.attribute...} or ${entity.sensor...}. Template should be updated to use ${entity.attributeWhenReady...} if that is required: " + TEMPLATE_FILE_WANTING_LEGACY_SYNTAX.peek());
                mode = SensorResolutionMode.ATTRIBUTE_WHEN_READY_FOR_TEMPLATES;
            }
            this.mode = mode;
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object result;
            try {
                result = this.mode == SensorResolutionMode.ATTRIBUTE_WHEN_READY_FOR_TEMPLATES ? this.entity.getExecutionContext().get(DependentConfiguration.attributeWhenReady((Entity)this.entity, Sensors.builder(Object.class, key).persistence(AttributeSensor.SensorPersistenceMode.NONE).build())) : (this.mode == SensorResolutionMode.ATTRIBUTE_WHEN_READY_FOR_WORKFLOW ? this.entity.getExecutionContext().get(DependentConfiguration.attributeWhenReadyAllowingOnFire((Entity)this.entity, Sensors.builder(Object.class, key).persistence(AttributeSensor.SensorPersistenceMode.NONE).build())) : (this.mode == SensorResolutionMode.ATTRIBUTE_VALUE ? this.entity.sensors().get(Sensors.newSensor(Object.class, key)) : (this.mode == SensorResolutionMode.SENSOR_DEFINITION ? this.entity.getEntityType().getSensor(key) : Exceptions.propagate((Throwable)new IllegalStateException("Invalid mode " + (Object)((Object)this.mode))))));
            }
            catch (Exception e) {
                throw TemplateProcessor.handleModelError("Error resolving attribute '" + key + "' on " + this.entity, e);
            }
            if (result == null) {
                return null;
            }
            return TemplateProcessor.wrapAsTemplateModel(result);
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.entity + "]";
        }

        static enum SensorResolutionMode {
            SENSOR_DEFINITION,
            ATTRIBUTE_VALUE,
            ATTRIBUTE_WHEN_READY_FOR_TEMPLATES,
            ATTRIBUTE_WHEN_READY_FOR_WORKFLOW;

        }
    }

    public static class TemplateModelDataUnavailableException
    extends TemplateModelException {
        public TemplateModelDataUnavailableException(String s, Throwable cause) {
            super(s, cause);
        }
    }

    protected static final class LocationConfigTemplateModel
    implements TemplateHashModel,
    UnwrappableTemplateModel {
        protected final LocationInternal location;
        protected final ManagementContext mgmt;

        protected LocationConfigTemplateModel(LocationInternal location) {
            this.location = (LocationInternal)Preconditions.checkNotNull((Object)location, (Object)"location");
            this.mgmt = location.getManagementContext();
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of((Object)this.location);
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                Object result = null;
                result = this.location.getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                if (result == null && this.mgmt != null) {
                    result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                }
                if (result != null) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw Exceptions.propagateAnnotated((String)("Error accessing config '" + key + "'" + (this.location != null ? " on " + this.location : "") + ": " + e), (Throwable)e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.location + "]";
        }
    }

    protected static final class MgmtConfigTemplateModel
    implements TemplateHashModel {
        protected final ManagementContext mgmt;

        protected MgmtConfigTemplateModel(ManagementContext mgmt) {
            this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                Object result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                if (result != null) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw Exceptions.propagateAnnotated((String)("Error accessing config '" + key + "': " + e), (Throwable)e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.mgmt + "]";
        }
    }

    protected static final class EntityConfigTemplateModel
    implements TemplateHashModel,
    UnwrappableTemplateModel {
        protected final EntityInternal entity;
        protected final ManagementContext mgmt;

        protected EntityConfigTemplateModel(EntityInternal entity) {
            this.entity = (EntityInternal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
            this.mgmt = entity.getManagementContext();
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of((Object)this.entity);
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                Object result = this.entity.getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                if (result == null) {
                    result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                }
                if (result != null) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                throw TemplateProcessor.handleModelError("Error accessing config '" + key + "' on " + this.entity, e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.entity + "]";
        }
    }

    public static final class DotSplittingTemplateModel
    implements TemplateHashModelEx2,
    UnwrappableTemplateModel {
        protected final Map<?, ?> map;

        protected DotSplittingTemplateModel(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of(this.map);
        }

        public boolean isEmpty() {
            return this.map != null && this.map.isEmpty();
        }

        public boolean contains(String key) {
            if (this.map == null) {
                return false;
            }
            if (this.map.containsKey(key)) {
                return true;
            }
            for (Map.Entry<?, ?> entry : this.map.entrySet()) {
                String k = Strings.toString(entry.getKey());
                if (!k.startsWith(key + ".")) continue;
                return true;
            }
            return false;
        }

        public TemplateModel get(String key) {
            if (this.map == null) {
                return null;
            }
            try {
                if (this.map.containsKey(key)) {
                    return TemplateProcessor.wrapAsTemplateModel(this.map.get(key));
                }
                MutableMap result = MutableMap.of();
                for (Map.Entry<?, ?> entry : this.map.entrySet()) {
                    String k = Strings.toString(entry.getKey());
                    if (!k.startsWith(key + ".")) continue;
                    String k2 = Strings.removeFromStart((String)k, (String)(key + "."));
                    result.put(k2, entry.getValue());
                }
                if (!result.isEmpty()) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Error accessing config '" + key + "': " + e, e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.map + "]";
        }

        public int size() {
            return this.map.size();
        }

        public TemplateCollectionModel keys() {
            return new SimpleCollection(this.map.keySet(), (ObjectWrapper)BROOKLYN_WRAPPER);
        }

        public TemplateCollectionModel values() {
            return new SimpleCollection(this.map.values(), (ObjectWrapper)BROOKLYN_WRAPPER);
        }

        public TemplateHashModelEx2.KeyValuePairIterator keyValuePairIterator() {
            return new MapKeyValuePairIterator(this.map, (ObjectWrapper)BROOKLYN_WRAPPER);
        }
    }

    public static final class FirstAvailableTemplateModel
    implements TemplateHashModel,
    UnwrappableTemplateModel {
        MutableList<TemplateHashModel> models = MutableList.of();

        public FirstAvailableTemplateModel(Iterable<TemplateHashModel> modelsO) {
            for (TemplateHashModel m : modelsO) {
                if (m == null) continue;
                this.models.add((Object)m);
            }
        }

        public FirstAvailableTemplateModel(TemplateHashModel ... modelsO) {
            this(Arrays.asList(modelsO));
        }

        @Override
        public Maybe<Object> unwrap() {
            return Maybe.of(this.models.stream().filter(m -> m instanceof UnwrappableTemplateModel).findAny()).mapMaybe(m -> ((UnwrappableTemplateModel)m).unwrap());
        }

        public TemplateModel get(String s) throws TemplateModelException {
            for (TemplateHashModel m : this.models) {
                TemplateModel result = m.get(s);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public boolean isEmpty() throws TemplateModelException {
            for (TemplateHashModel m : this.models) {
                if (m.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    static class SimpleSequenceWithLookup
    extends SimpleSequence
    implements TemplateHashModel {
        SimpleSequenceWithLookup(Collection<?> collection, ObjectWrapper wrapper) {
            super(collection, wrapper);
        }

        protected Object findKey(String key) {
            for (Object l : this.list) {
                String planId;
                if (l instanceof Entity && Strings.isNonEmpty((CharSequence)(planId = (String)((Entity)l).config().get(BrooklynConfigKeys.PLAN_ID))) && Objects.equals(planId, key)) {
                    return l;
                }
                if (!(l instanceof Identifiable) || !Objects.equals(((Identifiable)l).getId(), key)) continue;
                return l;
            }
            return null;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object match = this.findKey(key);
            if (match == null) {
                return null;
            }
            return this.getObjectWrapper().wrap(match);
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }

    static class BrooklynFreemarkerObjectWrapper
    extends DefaultObjectWrapper {
        static final ThreadLocal<Boolean> handleUnknownTypeLoopPrevention = new ThreadLocal();

        public BrooklynFreemarkerObjectWrapper() {
            this(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        }

        public BrooklynFreemarkerObjectWrapper(Version incompatibleImprovements) {
            super(incompatibleImprovements);
        }

        public TemplateModel wrap(Object obj) throws TemplateModelException {
            if (obj == null) {
                return super.wrap(null);
            }
            if (obj instanceof TemplateModel) {
                return (TemplateModel)obj;
            }
            if (obj instanceof Map) {
                return new DotSplittingTemplateModel((Map)obj);
            }
            if (obj instanceof Instant) {
                return super.wrap((Object)Date.from((Instant)obj));
            }
            Object objOrig = obj;
            if (obj.getClass().isArray()) {
                obj = this.convertArray(obj);
            }
            if (obj instanceof Collection) {
                if (((Collection)obj).isEmpty() || ((Collection)obj).stream().allMatch(x -> x instanceof Identifiable)) {
                    // empty if block
                }
                return new SimpleSequenceWithLookup((Collection)obj, (ObjectWrapper)this);
            }
            return super.wrap(objOrig);
        }

        protected TemplateModel handleUnknownType(Object o) throws TemplateModelException {
            if (handleUnknownTypeLoopPrevention.get() != null) {
                return super.handleUnknownType(o);
            }
            try {
                handleUnknownTypeLoopPrevention.set(true);
                while (true) {
                    try {
                        TemplateModel templateModel = this.handleUnknownTypeReal(o);
                        return templateModel;
                    }
                    catch (Exception e) {
                        if (WorkflowExpressionResolution.isInterruptSetToPreventWaiting() && (Exceptions.isRootCauseIsInterruption((Throwable)e) || e.toString().contains(InterruptedException.class.getSimpleName()))) {
                            Thread.yield();
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            finally {
                handleUnknownTypeLoopPrevention.remove();
            }
        }

        protected TemplateModel handleUnknownTypeReal(Object o) throws TemplateModelException {
            if (o instanceof EntityInternal) {
                return EntityAndMapTemplateModel.forEntity((Entity)((EntityInternal)o), null);
            }
            if (o instanceof Location) {
                return LocationAndMapTemplateModel.forLocation((LocationInternal)o, null);
            }
            return super.handleUnknownType(o);
        }

        public TemplateModel wrapAsBean(Object o) throws TemplateModelException {
            if (o instanceof BrooklynObject) {
                o = Entities.deproxy((BrooklynObject)o);
            }
            return this.handleUnknownType(o);
        }
    }

    static class BrooklynFreemarkerUnwrappableObjectWrapper
    extends BrooklynFreemarkerObjectWrapper {
        BrooklynFreemarkerUnwrappableObjectWrapper() {
        }

        public Maybe<Object> unwrapMaybe(TemplateModel model) {
            Maybe<Object> result;
            if (model instanceof UnwrappableTemplateModel && (result = ((UnwrappableTemplateModel)model).unwrap()).isPresent()) {
                return result;
            }
            Maybe unwrappingMapM = TEMPLATE_MODEL_UNWRAP_CACHE.peek();
            if (unwrappingMapM.isAbsent()) {
                return Maybe.absent((String)"This thread does not support unwrapping");
            }
            if (!((Map)unwrappingMapM.get()).containsKey(model)) {
                if (model instanceof TemplateScalarModel) {
                    try {
                        return Maybe.ofAllowingNull((Object)((TemplateScalarModel)model).getAsString());
                    }
                    catch (TemplateModelException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
                return Maybe.absent((String)("Type and source of model is unknown: " + model));
            }
            return Maybe.ofAllowingNull(((Map)unwrappingMapM.get()).get(model));
        }

        public TemplateModel rememberWrapperIfSupported(Object o, TemplateModel m) {
            Map unwrappingMap = (Map)TEMPLATE_MODEL_UNWRAP_CACHE.peek().orNull();
            if (unwrappingMap != null) {
                unwrappingMap.put(m, o);
            }
            return m;
        }

        @Override
        public TemplateModel wrap(Object o) throws TemplateModelException {
            return this.rememberWrapperIfSupported(o, super.wrap(o));
        }

        @Override
        public TemplateModel wrapAsBean(Object o) throws TemplateModelException {
            return this.rememberWrapperIfSupported(o, super.wrapAsBean(o));
        }
    }

    public static interface UnwrappableTemplateModel {
        public Maybe<Object> unwrap();
    }
}

