/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.system;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.text.Strings;

public class ProcessTaskStub {
    protected final List<String> commands = new ArrayList<String>();
    protected MachineLocation machine;
    protected RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability;
    protected String summary;
    protected Function<List<String>, List<String>> commandModifier;
    protected final ConfigBag config = ConfigBag.newInstance();
    protected Function<ProcessTaskWrapper<?>, ?> returnResultTransformation = null;
    protected ScriptReturnType returnType = ScriptReturnType.EXIT_CODE;
    protected Boolean runAsScript = null;
    protected boolean runAsRoot = false;
    protected Boolean requireExitCodeZero = null;
    protected String extraErrorMessage = null;
    protected Map<String, String> shellEnvironment = new MutableMap();
    protected final List<Function<ProcessTaskWrapper<?>, Void>> completionListeners = new ArrayList();

    public ProcessTaskStub() {
    }

    protected ProcessTaskStub(ProcessTaskStub source) {
        this.commands.addAll(source.getCommands(false));
        this.machine = source.getMachine();
        this.remoteExecCapability = source.getRemoteExecCapability();
        this.summary = source.getSummary();
        this.config.copy(source.getConfig());
        this.commandModifier = source.commandModifier;
        this.returnResultTransformation = source.returnResultTransformation;
        this.returnType = source.returnType;
        this.runAsScript = source.runAsScript;
        this.runAsRoot = source.runAsRoot;
        this.requireExitCodeZero = source.requireExitCodeZero;
        this.extraErrorMessage = source.extraErrorMessage;
        this.shellEnvironment.putAll(source.getShellEnvironment());
        this.completionListeners.addAll(source.getCompletionListeners());
    }

    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return Strings.maxlen((String)Strings.join(this.commands, (String)" ; "), (int)160);
    }

    public MachineLocation getMachine() {
        return this.machine;
    }

    public RemoteExecTaskConfigHelper.RemoteExecCapability getRemoteExecCapability() {
        if (this.remoteExecCapability != null) {
            return this.remoteExecCapability;
        }
        if (this.machine != null) {
            this.remoteExecCapability = new RemoteExecTaskConfigHelper.RemoteExecCapabilityFromLocation(this.machine);
            return this.remoteExecCapability;
        }
        return null;
    }

    public Map<String, String> getShellEnvironment() {
        return ImmutableMap.copyOf(this.shellEnvironment);
    }

    public String toString() {
        return super.toString() + "[" + this.getSummary() + "]";
    }

    public List<String> getCommands() {
        return this.getCommands(false);
    }

    public List<String> getCommands(boolean modified) {
        return ImmutableList.copyOf(modified && this.commandModifier != null ? (Collection)this.commandModifier.apply(this.commands) : this.commands);
    }

    public List<Function<ProcessTaskWrapper<?>, Void>> getCompletionListeners() {
        return this.completionListeners;
    }

    protected ConfigBag getConfig() {
        return this.config;
    }

    public static enum ScriptReturnType {
        CUSTOM,
        EXIT_CODE,
        STDOUT_STRING,
        STDOUT_BYTES,
        STDERR_STRING,
        STDERR_BYTES;

    }
}

