/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.ssh;

import com.google.common.base.Supplier;
import java.io.InputStream;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;

public class SshPutTaskStub {
    protected String remoteFile;
    protected SshMachineLocation machine;
    protected RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability;
    protected Supplier<? extends InputStream> contents;
    protected String summary;
    protected String permissions;
    protected boolean allowFailure = false;
    protected boolean createDirectory = false;
    protected final ConfigBag config = ConfigBag.newInstance();

    protected SshPutTaskStub() {
    }

    protected SshPutTaskStub(SshPutTaskStub constructor) {
        this.remoteFile = constructor.remoteFile;
        this.machine = constructor.machine;
        this.remoteExecCapability = constructor.remoteExecCapability;
        this.contents = constructor.contents;
        this.summary = constructor.summary;
        this.allowFailure = constructor.allowFailure;
        this.createDirectory = constructor.createDirectory;
        this.permissions = constructor.permissions;
        this.config.copy(constructor.config);
    }

    public String getRemoteFile() {
        return this.remoteFile;
    }

    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return "scp put: " + this.remoteFile;
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public RemoteExecTaskConfigHelper.RemoteExecCapability getRemoteExecCapability() {
        if (this.remoteExecCapability != null) {
            return this.remoteExecCapability;
        }
        if (this.machine != null) {
            this.remoteExecCapability = new RemoteExecTaskConfigHelper.RemoteExecCapabilityFromLocation(this.machine);
            return this.remoteExecCapability;
        }
        return null;
    }

    protected ConfigBag getConfig() {
        return this.config;
    }
}

