/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.file;

import java.util.Map;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.net.Urls;

public class ArchiveTasks {
    public static TaskFactory<?> deploy(ResourceUtils optionalResolver, String archiveUrl, SshMachineLocation machine, String destDir) {
        return ArchiveTasks.deploy(optionalResolver, null, archiveUrl, machine, destDir, false, null, null);
    }

    public static TaskFactory<?> deploy(final ResourceUtils resolver, final Map<String, ?> props, final String archiveUrl, final SshMachineLocation machine, final String destDir, final boolean allowNonarchivesOrKeepArchiveAfterDeploy, final String optionalTmpDir, final String optionalDestFile) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                return Tasks.builder().displayName("deploying " + Urls.getBasename((String)archiveUrl)).description("installing " + archiveUrl + " and unpacking to " + destDir).body(new Runnable(){

                    @Override
                    public void run() {
                        boolean unpacked = ArchiveUtils.deploy(resolver, props, archiveUrl, machine, destDir, allowNonarchivesOrKeepArchiveAfterDeploy, optionalTmpDir, optionalDestFile);
                        if (!unpacked && !allowNonarchivesOrKeepArchiveAfterDeploy) {
                            throw new IllegalStateException("Unable to unpack archive from " + archiveUrl + "; not able to infer archive type");
                        }
                    }
                }).build();
            }
        };
    }
}

