/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.entity.stock.DataEntity;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;

public class DataEntityImpl
extends AbstractEntity
implements DataEntity {
    private FunctionFeed feed;

    @Override
    public void start(Collection<? extends Location> locations) {
        this.addLocations(locations);
        this.connectSensors();
        this.sensors().set(SERVICE_UP, Boolean.TRUE);
    }

    @Override
    public void stop() {
        this.sensors().set(SERVICE_UP, Boolean.FALSE);
        this.disconnectSensors();
    }

    @Override
    public void restart() {
        this.stop();
        this.start(this.getLocations());
    }

    protected void connectSensors() {
        FunctionFeed.Builder builder = FunctionFeed.builder().entity(this).period((Long)this.getConfig(POLL_PERIOD));
        Map map = (Map)this.getConfig(SENSOR_SUPPLIER_MAP);
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeSensor sensor = (AttributeSensor)entry.getKey();
                Supplier supplier = (Supplier)entry.getValue();
                builder.poll((FunctionPollConfig)new FunctionPollConfig(sensor).supplier(supplier).onFailureOrException(Functions.constant(null)));
            }
        }
        this.feed = builder.build(true);
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
    }
}

