/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.group.DynamicGroupImpl;
import org.apache.brooklyn.entity.group.SequenceGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGroupImpl
extends DynamicGroupImpl
implements SequenceGroup {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceGroup.class);

    @Override
    public void init() {
        super.init();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void reset() {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            this.sensors().set(SEQUENCE_CACHE, Maps.newConcurrentMap());
            this.sensors().set(SEQUENCE_CURRENT, null);
            Integer initial = (Integer)this.config().get(SEQUENCE_START);
            AtomicInteger state = new AtomicInteger(initial);
            this.sensors().set(SEQUENCE_STATE, state);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMember(Entity member) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            Map cache;
            boolean changed = super.addMember(member);
            if (changed && !(cache = (Map)this.sensors().get(SEQUENCE_CACHE)).containsKey(member.getId())) {
                Integer value = this.sequence(member);
                cache.put(member.getId(), value);
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMember(Entity member) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            Map cache;
            boolean changed = super.removeMember(member);
            if (changed && (cache = (Map)this.sensors().get(SEQUENCE_CACHE)).containsKey(member.getId())) {
                cache.remove(member.getId());
                AttributeSensor valueSensor = (AttributeSensor)this.config().get(SEQUENCE_VALUE_SENSOR);
                AttributeSensor stringSensor = (AttributeSensor)this.config().get(SEQUENCE_STRING_SENSOR);
                member.sensors().set(valueSensor, null);
                member.sensors().set(stringSensor, null);
            }
            return changed;
        }
    }

    private Integer sequence(Entity entity) {
        String format = (String)this.config().get(SEQUENCE_FORMAT);
        Integer increment = (Integer)this.config().get(SEQUENCE_INCREMENT);
        AtomicInteger state = (AtomicInteger)this.sensors().get(SEQUENCE_STATE);
        Integer current = state.getAndAdd(increment);
        String string = String.format(format, current);
        AttributeSensor valueSensor = (AttributeSensor)this.config().get(SEQUENCE_VALUE_SENSOR);
        AttributeSensor stringSensor = (AttributeSensor)this.config().get(SEQUENCE_STRING_SENSOR);
        entity.sensors().set(valueSensor, (Object)current);
        entity.sensors().set(stringSensor, (Object)string);
        LOG.debug("Sequence on {} set to to {}", (Object)entity, (Object)current);
        this.sensors().set(SEQUENCE_CURRENT, entity);
        LOG.debug("Sequence for {} incremented to {}", (Object)this, (Object)state.get());
        return current;
    }
}

