/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.store.WorkflowRetentionAndExpiration;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class WorkflowRetentionParser {
    String fullExpression;
    String rest;

    public static WorkflowRetentionAndExpiration.WorkflowRetentionSettings parse(String retentionExpression, @Nullable WorkflowExecutionContext context) {
        WorkflowRetentionAndExpiration.WorkflowRetentionSettings result = new WorkflowRetentionAndExpiration.WorkflowRetentionSettings();
        if (Strings.isBlank((CharSequence)retentionExpression)) {
            return result;
        }
        if ((retentionExpression = retentionExpression.trim().toLowerCase()).equals("disabled")) {
            result.disabled = true;
        } else {
            if (retentionExpression.startsWith("hash ")) {
                retentionExpression = Strings.removeFromStart((String)retentionExpression, (String)"hash").trim();
                result.hash = Strings.getFirstWord((String)retentionExpression);
                retentionExpression = retentionExpression.substring(result.hash.length()).trim();
            } else if (retentionExpression.contains(" hash ")) {
                int i = retentionExpression.indexOf(" hash ");
                result.hash = Strings.removeFromStart((String)retentionExpression.substring(i).trim(), (String)"hash").trim();
                retentionExpression = retentionExpression.substring(0, i).trim();
            }
            if (Strings.isNonBlank((CharSequence)result.hash) && context != null) {
                result.hash = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, (Object)result.hash, String.class);
            }
            if (Strings.isBlank((CharSequence)retentionExpression)) {
                return result;
            }
            result.expiry = retentionExpression;
            new WorkflowRetentionParser(result.expiry).parse();
        }
        return result;
    }

    public static WorkflowRetentionFilter newDefaultFilter() {
        return new KeepParent();
    }

    public WorkflowRetentionParser(String fullExpression) {
        this.fullExpression = fullExpression;
    }

    public WorkflowRetentionFilter parse() {
        if (Strings.isBlank((CharSequence)this.fullExpression)) {
            return WorkflowRetentionParser.newDefaultFilter();
        }
        this.rest = Strings.trimStart((String)this.fullExpression.toLowerCase());
        WorkflowRetentionFilter result = this.parseTerm();
        if (!Strings.isBlank((CharSequence)this.rest)) {
            return WorkflowRetentionParser.newDefaultFilter();
        }
        return result;
    }

    Maybe<WorkflowRetentionFilter> eatFn(String word, Function<List<WorkflowRetentionFilter>, WorkflowRetentionFilter> fn) {
        if (this.eatNA(word)) {
            List<WorkflowRetentionFilter> args = this.parseGroupedList(false);
            return Maybe.of((Object)fn.apply(args));
        }
        return Maybe.absent();
    }

    public <T> T notNull(T value, String message) {
        if (value != null) {
            return value;
        }
        throw this.error(message);
    }

    public boolean eat(String word) {
        return this.eat(word, false);
    }

    public boolean eat(String word, boolean requireNextNonAlpha) {
        if (this.rest.startsWith(word)) {
            this.rest = this.rest.substring(word.length());
            if (requireNextNonAlpha && !this.rest.isEmpty() && Character.isJavaIdentifierPart(this.rest.charAt(0))) {
                this.rest = word + this.rest;
                return false;
            }
            this.rest = Strings.trimStart((String)this.rest);
            return true;
        }
        return false;
    }

    public boolean eatNA(String word) {
        return this.eat(word, true);
    }

    protected RuntimeException error(String prefix) {
        throw new IllegalArgumentException(prefix + " at position " + (this.fullExpression.length() - this.rest.length()));
    }

    public List<WorkflowRetentionFilter> parseGroupedList(boolean consumedStart) {
        WorkflowRetentionFilter expr;
        if (!consumedStart && !this.eat("(")) {
            throw new IllegalStateException("Expected '('");
        }
        MutableList terms = MutableList.of();
        while ((expr = this.parseTerm()) != null) {
            terms.add(expr);
            if (this.eat(",")) continue;
            break;
        }
        if (!this.eat(")")) {
            throw new IllegalStateException("Expected ')'");
        }
        return terms;
    }

    public WorkflowRetentionFilter parseTerm() {
        Maybe<WorkflowRetentionFilter> term = this.eatFn("min", KeepMin::new);
        if (term.isPresent()) {
            return (WorkflowRetentionFilter)term.get();
        }
        term = this.eatFn("max", KeepMax::new);
        if (term.isPresent()) {
            return (WorkflowRetentionFilter)term.get();
        }
        if (this.eatNA("all") || this.eatNA("forever")) {
            return new KeepAll();
        }
        if (this.eatNA("system")) {
            return new KeepSystem();
        }
        if (this.eatNA("parent")) {
            return new KeepParent();
        }
        if (this.eatNA("context")) {
            return new KeepContext();
        }
        int i = this.maxPositive(this.rest.indexOf(","), this.rest.indexOf(")"));
        if (i == -1) {
            i = this.rest.length();
        }
        String nextWord = this.rest.substring(0, i).trim();
        this.rest = this.rest.substring(i);
        if (nextWord.matches("[0-9]+")) {
            return new KeepCount(Integer.parseInt(nextWord));
        }
        try {
            return new KeepDuration(Duration.of((Object)nextWord));
        }
        catch (Exception e) {
            throw this.error("Expected a valid retention term, instead had '" + nextWord + "'");
        }
    }

    private int maxPositive(int i1, int i2) {
        if (i1 < 0) {
            return i2;
        }
        if (i2 < 0) {
            return i1;
        }
        return Math.min(i1, i2);
    }

    static class KeepContext
    extends KeepDelegate {
        KeepContext() {
        }

        @Override
        public WorkflowRetentionFilter findDelegate(WorkflowExecutionContext workflow) {
            if (workflow == null) {
                throw new IllegalStateException("Retention 'context' cannot be used here");
            }
            return workflow.getRetentionSettings().getExpiryFn(workflow);
        }

        public String toString() {
            return this.delegate == null ? "context" : this.delegate.toString();
        }
    }

    static class KeepParent
    extends KeepDelegate {
        KeepParent() {
        }

        @Override
        public WorkflowRetentionFilter findDelegate(WorkflowExecutionContext workflow) {
            if (workflow == null) {
                throw new IllegalStateException("Retention 'parent' cannot be used here");
            }
            if (workflow.getParent() != null) {
                return workflow.getParent().getRetentionSettings().getExpiryFn(workflow.getParent());
            }
            return new KeepSystem().init(workflow);
        }

        public String toString() {
            return "parent";
        }
    }

    static class KeepSystem
    extends KeepDelegate {
        KeepSystem() {
        }

        @Override
        public WorkflowRetentionFilter findDelegate(WorkflowExecutionContext workflow) {
            if (workflow == null) {
                throw new IllegalStateException("Retention 'system' cannot be used here");
            }
            return new WorkflowRetentionParser((String)workflow.getManagementContext().getConfig().getConfig(WorkflowRetentionAndExpiration.WORKFLOW_RETENTION_DEFAULT)).parse().init(null);
        }

        public String toString() {
            return "system";
        }
    }

    static abstract class KeepDelegate
    implements WorkflowRetentionFilter {
        WorkflowRetentionFilter delegate;

        KeepDelegate() {
        }

        @Override
        public Collection<WorkflowExecutionContext> apply(Collection<WorkflowExecutionContext> workflowExecutionContexts) {
            if (this.delegate == null) {
                throw new IllegalStateException("Not initialized");
            }
            return (Collection)this.delegate.apply(workflowExecutionContexts);
        }

        @Override
        public final WorkflowRetentionFilter init(WorkflowExecutionContext workflow) {
            if (this.delegate == null) {
                this.delegate = this.findDelegate(workflow);
            }
            return this;
        }

        protected abstract WorkflowRetentionFilter findDelegate(WorkflowExecutionContext var1);
    }

    static class KeepDuration
    implements WorkflowRetentionFilter {
        private final Duration duration;

        KeepDuration(Duration duration) {
            this.duration = duration;
        }

        @Override
        public Collection<WorkflowExecutionContext> apply(Collection<WorkflowExecutionContext> workflowExecutionContexts) {
            Instant expiry = Instant.now().minus(this.duration.toMilliseconds() + 1L, ChronoUnit.MILLIS);
            return workflowExecutionContexts.stream().filter(c -> c.getLastStatusChangeTime().isAfter(expiry)).collect(Collectors.toList());
        }

        public String toString() {
            return "" + this.duration;
        }
    }

    static class KeepCount
    implements WorkflowRetentionFilter {
        private final int count;

        KeepCount(int count) {
            this.count = count;
        }

        @Override
        public Collection<WorkflowExecutionContext> apply(Collection<WorkflowExecutionContext> workflowExecutionContexts) {
            if (workflowExecutionContexts.size() > this.count) {
                return workflowExecutionContexts.stream().sorted(Comparator.comparing(WorkflowExecutionContext::getLastStatusChangeTime).reversed()).limit(this.count).collect(Collectors.toList());
            }
            return workflowExecutionContexts;
        }

        public String toString() {
            return "" + this.count;
        }
    }

    static class KeepMin
    implements WorkflowRetentionFilter {
        private final List<WorkflowRetentionFilter> values;

        KeepMin(List<WorkflowRetentionFilter> values) {
            this.values = values;
        }

        @Override
        public Collection<WorkflowExecutionContext> apply(Collection<WorkflowExecutionContext> workflowExecutionContexts) {
            List workflowsToKeep = this.values.stream().map(v -> (Collection)v.apply(workflowExecutionContexts)).collect(Collectors.toList());
            Iterator wi = workflowsToKeep.iterator();
            if (!wi.hasNext()) {
                return workflowExecutionContexts;
            }
            MutableSet intersection = MutableSet.copyOf((Iterable)((Iterable)wi.next()));
            while (wi.hasNext()) {
                intersection.retainAll((Collection)wi.next());
            }
            return intersection;
        }

        public String toString() {
            return "min(" + this.values.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
        }

        @Override
        public WorkflowRetentionFilter init(WorkflowExecutionContext context) {
            this.values.forEach(v -> v.init(context));
            return WorkflowRetentionFilter.super.init(context);
        }
    }

    static class KeepMax
    implements WorkflowRetentionFilter {
        private final List<WorkflowRetentionFilter> values;

        KeepMax(List<WorkflowRetentionFilter> values) {
            this.values = values;
        }

        @Override
        public Collection<WorkflowExecutionContext> apply(Collection<WorkflowExecutionContext> workflowExecutionContexts) {
            return this.values.stream().map(v -> (Collection)v.apply(workflowExecutionContexts)).reduce((Collection)MutableSet.of(), (t1, t2) -> {
                t1.addAll(t2);
                return t1;
            });
        }

        public String toString() {
            return "max(" + this.values.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
        }

        @Override
        public WorkflowRetentionFilter init(WorkflowExecutionContext context) {
            this.values.forEach(v -> v.init(context));
            return WorkflowRetentionFilter.super.init(context);
        }
    }

    static class KeepAll
    implements WorkflowRetentionFilter {
        KeepAll() {
        }

        @Override
        public Collection<WorkflowExecutionContext> apply(Collection<WorkflowExecutionContext> workflowExecutionContexts) {
            return workflowExecutionContexts;
        }

        public String toString() {
            return "forever";
        }
    }

    public static interface WorkflowRetentionFilter
    extends Function<Collection<WorkflowExecutionContext>, Collection<WorkflowExecutionContext>> {
        default public WorkflowRetentionFilter init(WorkflowExecutionContext context) {
            return this;
        }
    }
}

