/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.appmodel.DeployApplicationWorkflowStep;
import org.apache.brooklyn.core.workflow.steps.appmodel.HasBlueprintWorkflowStep;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEntityWorkflowStep
extends WorkflowStepDefinition
implements HasBlueprintWorkflowStep {
    private static final Logger LOG = LoggerFactory.getLogger(AddEntityWorkflowStep.class);
    public static final String SHORTHAND = "[ ${type} ]";
    public static final ConfigKey<String> FORMAT = ConfigKeys.newStringConfigKey("format");
    public static final ConfigKey<DeployApplicationWorkflowStep.StartMode> START = ConfigKeys.newConfigKey(DeployApplicationWorkflowStep.StartMode.class, "start", "Default 'async'");

    @Override
    public Logger logger() {
        return LOG;
    }

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        this.validateStepBlueprint(mgmt, workflow);
    }

    @Override
    protected List<String> getStepState(WorkflowStepInstanceExecutionContext context) {
        return (List)super.getStepState(context);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, List<String> entityIds) {
        context.setStepState(entityIds, true);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        MutableList specs;
        Object blueprint = this.resolveBlueprint(context);
        List preCreatedEntityIds = (List)Maybe.ofDisallowingNull((Object)this.getStepState(context)).map(MutableList::copyOf).orNull();
        MutableList newCreatedEntityIds = MutableList.of();
        ManagementContext mgmt = context.getManagementContext();
        try {
            specs = blueprint instanceof EntitySpec ? MutableList.of((Object)((EntitySpec)blueprint)) : EntityManagementUtils.getAddChildrenSpecs(mgmt, blueprint instanceof String ? (String)blueprint : BeanWithTypeUtils.newYamlMapper(mgmt, false, null, false).writeValueAsString(blueprint));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        specs.forEach(spec -> spec.parent(Entities.proxy(context.getEntity())));
        DeployApplicationWorkflowStep.StartMode start = context.getInput(START);
        MutableList startTasks = MutableList.of();
        MutableList childEntities = MutableList.of();
        MutableMap result = MutableMap.of((Object)"entities", (Object)childEntities);
        context.setOutput(result);
        MutableMap specsToCreate = MutableMap.of();
        specs.forEach(arg_0 -> AddEntityWorkflowStep.lambda$doTaskBody$1(preCreatedEntityIds, context, (Map)specsToCreate, (List)childEntities, (List)newCreatedEntityIds, arg_0));
        this.setStepState(context, (List<String>)newCreatedEntityIds);
        specsToCreate.forEach((arg_0, arg_1) -> AddEntityWorkflowStep.lambda$doTaskBody$3(context, mgmt, (List)childEntities, start, (List)startTasks, arg_0, arg_1));
        if (childEntities.size() == 1) {
            result.put("entity", Iterables.getOnlyElement((Iterable)childEntities));
        }
        if (start == DeployApplicationWorkflowStep.StartMode.SYNC) {
            startTasks.forEach(Task::getUnchecked);
        }
        return context.getOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    private static /* synthetic */ void lambda$doTaskBody$3(WorkflowStepInstanceExecutionContext context, ManagementContext mgmt, List childEntities, DeployApplicationWorkflowStep.StartMode start, List startTasks, String entityId, EntitySpec spec) {
        Entity child = (Entity)((EntityInternal)context.getEntity()).getExecutionContext().get(Tasks.builder().dynamic(false).displayName("Creating entity " + (Strings.isNonBlank((CharSequence)spec.getDisplayName()) ? spec.getDisplayName() : spec.getType().getName())).body(() -> ((EntityManagerInternal)mgmt.getEntityManager()).createEntity(spec, (Optional<String>)Optional.of((Object)entityId))).build());
        childEntities.add(child);
        if (start != DeployApplicationWorkflowStep.StartMode.DISABLED && child instanceof Startable) {
            startTasks.add(Entities.submit(child, Effectors.invocation(child, Startable.START, ImmutableMap.of((Object)"locations", (Object)ImmutableList.of()))).asTask());
        }
    }

    private static /* synthetic */ void lambda$doTaskBody$1(List preCreatedEntityIds, WorkflowStepInstanceExecutionContext context, Map specsToCreate, List childEntities, List newCreatedEntityIds, EntitySpec spec) {
        String entityId;
        Entity child = null;
        if (preCreatedEntityIds != null) {
            entityId = (String)preCreatedEntityIds.remove(0);
            child = context.getManagementContext().getEntityManager().getEntity(entityId);
        } else {
            entityId = Identifiers.makeRandomLowercaseId((int)10);
        }
        if (child == null) {
            specsToCreate.put(entityId, spec);
        } else {
            childEntities.add(child);
        }
        newCreatedEntityIds.add(entityId);
    }
}

