/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityTypeRegistry;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.internal.BrooklynLoggingCategories;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.EntityManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConstraintViolationException;
import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPostInitializable;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.proxy.ClassLoaderCache;
import org.apache.brooklyn.core.objs.proxy.EntityProxy;
import org.apache.brooklyn.core.objs.proxy.EntityProxyImpl;
import org.apache.brooklyn.core.objs.proxy.InternalFactory;
import org.apache.brooklyn.core.objs.proxy.InternalPolicyFactory;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.AggregateClassLoader;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalEntityFactory
extends InternalFactory {
    private static final Logger log = LoggerFactory.getLogger(InternalEntityFactory.class);
    private final EntityTypeRegistry entityTypeRegistry;
    private final InternalPolicyFactory policyFactory;
    private final ClassLoaderCache classLoaderCache;
    public static final ConfigKey<String> GLOBAL_DEPLOYMENT_INITIALIZER_CLASSNAMES = ConfigKeys.newStringConfigKey("brooklyn.deployment.initializers", "Comma separated list of class names corresponding to Brooklyn Initializers to be automatically added and ran on every application deployed", "");

    public InternalEntityFactory(ManagementContextInternal managementContext, EntityTypeRegistry entityTypeRegistry, InternalPolicyFactory policyFactory) {
        super(managementContext);
        this.entityTypeRegistry = (EntityTypeRegistry)Preconditions.checkNotNull((Object)entityTypeRegistry, (Object)"entityTypeRegistry");
        this.policyFactory = (InternalPolicyFactory)Preconditions.checkNotNull((Object)policyFactory, (Object)"policyFactory");
        this.classLoaderCache = new ClassLoaderCache();
    }

    @VisibleForTesting
    public <T extends Entity> T createEntityProxy(EntitySpec<T> spec, T entity) {
        LinkedHashSet interfaces = Sets.newLinkedHashSet();
        if (spec.getType().isInterface()) {
            interfaces.add(spec.getType());
        } else {
            log.warn("EntitySpec declared in terms of concrete type " + spec.getType() + "; should be supplied in terms of interface");
            interfaces.addAll(Reflections.getAllInterfaces((Class)spec.getType()));
        }
        interfaces.addAll(spec.getAdditionalInterfaces());
        return this.createEntityProxy(interfaces, entity);
    }

    protected <T extends Entity> T createEntityProxy(Iterable<Class<?>> interfaces, T entity) {
        MutableSet allInterfaces = MutableSet.builder().add(EntityProxy.class, Entity.class, (Object[])new Class[]{EntityLocal.class, EntityInternal.class}).addAll(interfaces).build();
        AggregateClassLoader aggregateClassLoader = this.classLoaderCache.getClassLoaderForProxy(entity.getClass(), (Set<Class<?>>)allInterfaces);
        return (T)((Entity)Proxy.newProxyInstance((ClassLoader)aggregateClassLoader, allInterfaces.toArray(new Class[allInterfaces.size()]), (InvocationHandler)new EntityProxyImpl(entity)));
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec) {
        return this.createEntity(spec, new EntityManager.EntityCreationOptions(){});
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec, final String entityId) {
        return this.createEntity(spec, new EntityManager.EntityCreationOptions(){

            public String getRequiredUniqueId() {
                return entityId;
            }
        });
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec, EntityManager.EntityCreationOptions options) {
        if (options == null) {
            options = new EntityManager.EntityCreationOptions(){};
        }
        MutableMap entitiesByEntityId = MutableMap.of();
        MutableMap specsByEntityId = MutableMap.of();
        Object entity = this.createEntityAndDescendantsUninitialized(0, spec, options, (Map<String, Entity>)entitiesByEntityId, (Map<String, EntitySpec<?>>)specsByEntityId);
        try {
            this.initEntityAndDescendants(entity.getId(), (Map<String, Entity>)entitiesByEntityId, (Map<String, EntitySpec<?>>)specsByEntityId, options);
        }
        catch (RuntimeException ex) {
            options.onException((Throwable)ex, e -> {
                Exceptions.propagateIfFatal((Throwable)e);
                log.info("Failed to initialise entity " + entity + " and its descendants - unmanaging and propagating original exception: " + Exceptions.collapseText((Throwable)e));
                try {
                    if (this.managementContext.isRunning()) {
                        ((EntityManagerInternal)this.managementContext.getEntityManager()).discardPremanaged((Entity)entity);
                    }
                }
                catch (Exception e2) {
                    Exceptions.propagateIfFatal((Throwable)e2);
                    log.info("Failed to unmanage entity " + entity + " and its descendants, after failure to initialise (rethrowing original exception)", (Throwable)e2);
                }
                throw e;
            });
        }
        return entity;
    }

    private <T extends Entity> T createEntityAndDescendantsUninitialized(int depth, EntitySpec<T> spec, EntityManager.EntityCreationOptions options, Map<String, Entity> entitiesByEntityId, Map<String, EntitySpec<?>> specsByEntityId) {
        Entity entity = null;
        try {
            if (spec.getFlags().containsKey("parent") || spec.getFlags().containsKey("owner")) {
                throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + spec);
            }
            if (spec.getFlags().containsKey("id")) {
                throw new IllegalArgumentException("Spec's flags must not contain id; use spec.id() instead for " + spec);
            }
            Class<T> clazz = this.getImplementedBy(spec);
            entity = (Entity)this.constructEntity(clazz, spec, depth == 0 ? options.getRequiredUniqueId() : null);
            if (!options.isDryRun()) {
                if (spec.getParent() == null) {
                    BrooklynLoggingCategories.APPLICATION_LIFECYCLE_LOG.debug("Creating application " + entity.getId() + " (" + entity + ") for user " + Entitlements.getEntitlementContextUser());
                } else {
                    BrooklynLoggingCategories.ENTITY_LIFECYCLE_LOG.debug("Creating entity " + entity.getId() + " (" + entity + ") for user " + Entitlements.getEntitlementContextUser() + ", child of " + (!Objects.equals(spec.getParent().getId(), spec.getParent().getApplicationId()) ? "entity " + spec.getParent().getId() + " in " : "") + "application " + spec.getParent().getApplicationId());
                }
            }
            this.loadUnitializedEntity(entity, spec, options);
            List<BrooklynTags.NamedStringTag> upgradedFrom = BrooklynTags.findAllNamedStringTags("upgraded_from", spec.getTags());
            if (!upgradedFrom.isEmpty()) {
                log.warn("Entity " + entity.getId() + " created with upgraded type " + entity.getCatalogItemId() + " " + upgradedFrom + " (in " + entity.getApplicationId() + ", under " + entity.getParent() + ")");
            }
            entitiesByEntityId.put(entity.getId(), entity);
            specsByEntityId.put(entity.getId(), spec);
            for (EntitySpec childSpec : spec.getChildren()) {
                if (childSpec.getParent() != null) {
                    if (!childSpec.getParent().equals(entity)) {
                        throw new IllegalStateException("Spec " + childSpec + " has parent " + childSpec.getParent() + " defined, but it is defined as a child of " + entity);
                    }
                    log.warn("Child spec " + childSpec + " is already set with parent " + entity + "; how did this happen?!");
                }
                childSpec.parent(entity);
                T child = this.createEntityAndDescendantsUninitialized(depth + 1, childSpec, options, entitiesByEntityId, specsByEntityId);
                if (Entities.isUnmanagingOrNoLongerManaged(entity)) {
                    throw new IllegalStateException("Cannot create " + child + " as child of " + entity + " because the latter is unmanaging or no longer managed");
                }
                entity.addChild(child);
            }
            for (Entity member : spec.getMembers()) {
                if (!(entity instanceof Group)) {
                    throw new IllegalStateException("Entity " + entity + " must be a group to add members " + spec.getMembers());
                }
                ((Group)entity).addMember(member);
            }
            for (Group group : spec.getGroups()) {
                group.addMember(entity);
            }
            return (T)entity;
        }
        catch (Exception ex) {
            options.onException((Throwable)ex, Exceptions::propagate);
            return (T)entity;
        }
    }

    protected <T extends Entity> T loadUnitializedEntity(T entity, EntitySpec<T> spec, EntityManager.EntityCreationOptions options) {
        try {
            Task<Entity> initialize = Tasks.create("Initialize model classes", () -> {
                AbstractEntity theEntity = (AbstractEntity)entity;
                if (spec.getDisplayName() != null) {
                    theEntity.setDisplayName(spec.getDisplayName());
                }
                if (spec.getCatalogItemId() != null) {
                    theEntity.setCatalogItemIdAndSearchPath(spec.getCatalogItemId(), spec.getCatalogItemIdSearchPath());
                } else {
                    theEntity.addSearchPath(spec.getCatalogItemIdSearchPath());
                }
                entity.tags().addTags((Iterable)spec.getTags());
                this.addSpecParameters(spec, theEntity.getMutableEntityType());
                MutableMap flags = MutableMap.copyOf((Map)spec.getFlags());
                Object extraTags = flags.remove("tags");
                if (extraTags != null) {
                    theEntity.tags().addTags(TypeCoercions.coerce(extraTags, Iterable.class));
                }
                theEntity.configure((Map)flags);
                for (Map.Entry entry : spec.getConfig().entrySet()) {
                    entity.config().set((ConfigKey)entry.getKey(), entry.getValue());
                }
                Entity parent = spec.getParent();
                if (parent != null) {
                    parent = parent instanceof AbstractEntity ? ((AbstractEntity)parent).getProxyIfAvailable() : parent;
                    entity.setParent(parent);
                }
                return entity;
            });
            return (T)((Entity)((AbstractEntity)entity).getExecutionContext().get(initialize));
        }
        catch (Exception e) {
            options.onException((Throwable)e, Exceptions::propagate);
            return entity;
        }
    }

    private void addSpecParameters(EntitySpec<?> spec, EntityDynamicType edType) {
        if (Strings.isNonBlank((CharSequence)spec.getCatalogItemId())) {
            edType.clearConfigKeys();
        }
        for (SpecParameter param : spec.getParameters()) {
            edType.addConfigKey(param.getConfigKey());
            if (param.getSensor() == null) continue;
            edType.addSensor((Sensor<?>)param.getSensor());
        }
    }

    private void validateDescendantConfig(Entity e, EntityManager.EntityCreationOptions options) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(e);
        while (!queue.isEmpty()) {
            Entity e1 = (Entity)queue.poll();
            try {
                ConfigConstraints.assertValid(e1);
            }
            catch (ConstraintViolationException ex) {
                options.onException((Throwable)((Object)ex), Exceptions::propagate);
            }
            queue.addAll(e1.getChildren());
        }
    }

    protected <T extends Entity> void initEntityAndDescendants(String entityId, final Map<String, Entity> entitiesByEntityId, final Map<String, EntitySpec<?>> specsByEntityId, final EntityManager.EntityCreationOptions options) {
        final Entity entity = entitiesByEntityId.get(entityId);
        final EntitySpec<?> spec = specsByEntityId.get(entityId);
        if (entity == null || spec == null) {
            log.debug("Skipping initialization of " + entityId + " found as child of entity being initialized, but this child is not one we created; likely it was created by an initializer, and thus it should be already fully initialized.");
            return;
        }
        this.validateDescendantConfig(entity, options);
        ((EntityInternal)entity).getExecutionContext().get(Tasks.builder().dynamic(false).displayName("Entity initialization").body(new Runnable(){

            @Override
            public void run() {
                ((AbstractEntity)entity).init();
                for (LocationSpec locationSpec : spec.getLocationSpecs()) {
                    LocationSpec taggedSpec = (LocationSpec)LocationSpec.create((LocationSpec)locationSpec).tag((Object)BrooklynTags.newOwnerEntityTag(entity.getId()));
                    ((AbstractEntity)entity).addLocations((Collection<? extends Location>)MutableList.of((Object)InternalEntityFactory.this.managementContext.getLocationManager().createLocation(taggedSpec)));
                }
                ((AbstractEntity)entity).addLocations(spec.getLocations());
                List initializers = Stream.concat(InternalEntityFactory.this.getGlobalDeploymentInitializers().stream(), spec.getInitializers().stream()).collect(Collectors.toList());
                for (EntityInitializer initializer : initializers) {
                    initializer.apply((EntityLocal)((EntityInternal)entity));
                }
                for (EnricherSpec enricherSpec : spec.getEnricherSpecs()) {
                    entity.enrichers().add(InternalEntityFactory.this.policyFactory.createEnricher(enricherSpec));
                }
                for (PolicySpec policySpec : spec.getPolicySpecs()) {
                    entity.policies().add(InternalEntityFactory.this.policyFactory.createPolicy(policySpec));
                }
                for (Entity child : entity.getChildren()) {
                    InternalEntityFactory.this.initEntityAndDescendants(child.getId(), entitiesByEntityId, specsByEntityId, options);
                }
                if (entity instanceof EntityPostInitializable) {
                    ((EntityPostInitializable)entity).postInit();
                }
            }
        }).build());
    }

    private <T extends Entity> T constructEntity(Class<? extends T> clazz, EntitySpec<T> spec, String entityId) {
        T entity = this.constructEntityImpl(clazz, spec, null, entityId);
        if (((AbstractEntity)entity).getProxy() == null) {
            ((AbstractEntity)entity).setProxy((Entity)this.createEntityProxy(spec, entity));
        }
        return entity;
    }

    public <T extends Entity> T constructEntity(Class<T> clazz, Iterable<Class<?>> interfaces, String entityId) {
        if (!InternalEntityFactory.isNewStyle(clazz)) {
            throw new IllegalStateException("Cannot construct old-style entity " + clazz);
        }
        Preconditions.checkNotNull((Object)entityId, (Object)"entityId");
        Preconditions.checkState((interfaces != null && !Iterables.isEmpty(interfaces) ? 1 : 0) != 0, (String)"must have at least one interface for entity %s:%s", clazz, (Object)entityId);
        T entity = this.constructEntityImpl(clazz, null, null, entityId);
        if (((AbstractEntity)entity).getProxy() == null) {
            Object proxy = this.managementContext.getEntityManager().getEntity(entity.getId());
            if (proxy == null) {
                proxy = this.createEntityProxy(interfaces, entity);
            }
            ((AbstractEntity)entity).setProxy((Entity)proxy);
        }
        return entity;
    }

    private <T extends Entity> T constructEntityImpl(Class<? extends T> clazz, EntitySpec<?> optionalSpec, Map<String, ?> optionalConstructorFlags, String entityId) {
        Entity entity = (Entity)this.construct(clazz, (AbstractBrooklynObjectSpec<?, ?>)optionalSpec, optionalConstructorFlags);
        if (entityId != null) {
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)entityId), entity);
        }
        if (entity instanceof AbstractApplication) {
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"mgmt", (Object)this.managementContext), entity);
        }
        this.managementContext.prePreManage(entity);
        ((AbstractEntity)entity).setManagementContext(this.managementContext);
        return (T)entity;
    }

    @Override
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (flags.containsKey("parent") || flags.containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + clazz);
        }
        return super.constructOldStyle(clazz, flags);
    }

    private <T extends Entity> Class<? extends T> getImplementedBy(EntitySpec<T> spec) {
        if (spec.getImplementation() != null) {
            return spec.getImplementation();
        }
        return this.entityTypeRegistry.getImplementedBy(spec.getType());
    }

    private List<EntityInitializer> getGlobalDeploymentInitializers() {
        return Arrays.stream(((String)this.managementContext.getConfig().getConfig(GLOBAL_DEPLOYMENT_INITIALIZER_CLASSNAMES)).split(",")).filter(Strings::isNonEmpty).map(className -> (EntityInitializer)this.managementContext.getTypeRegistry().getMaybe(className, null).map(registeredType -> (EntityInitializer)this.managementContext.getTypeRegistry().create(registeredType, null, null)).or(() -> (EntityInitializer)JavaBrooklynClassLoadingContext.create(this.managementContext).tryLoadClass((String)className).map(aClass -> {
            try {
                return (EntityInitializer)aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }).or(() -> {
            log.warn("Cannot find initializer '" + className + "'; not in type registry and not found on default classpath; ignoring");
            return null;
        }))).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

