/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.usage;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.usage.ApplicationUsage;
import org.apache.brooklyn.core.mgmt.usage.LocationUsage;
import org.apache.brooklyn.core.mgmt.usage.UsageListener;
import org.apache.brooklyn.util.time.Duration;

@Beta
public interface UsageManager {
    public static final ConfigKey<List<UsageListener>> USAGE_LISTENERS = ConfigKeys.newConfigKey(new TypeToken<List<UsageListener>>(){}, "brooklyn.usageManager.listeners", "Optional list of usage listener instances (e.g. for metering)", ImmutableList.of());
    public static final ConfigKey<Duration> USAGE_LISTENER_TERMINATION_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, "brooklyn.usageManager.listeners.timeout", "Timeout on termination, to wait for queue of usage listener events to be processed", Duration.TEN_SECONDS);

    public void recordApplicationEvent(Application var1, Lifecycle var2);

    public void recordLocationEvent(Location var1, Lifecycle var2);

    public LocationUsage getLocationUsage(String var1);

    public Set<LocationUsage> getLocationUsage(Predicate<? super LocationUsage> var1);

    public ApplicationUsage getApplicationUsage(String var1);

    public Set<ApplicationUsage> getApplicationUsage(Predicate<? super ApplicationUsage> var1);

    public void addUsageListener(UsageListener var1);

    public void removeUsageListener(UsageListener var1);
}

