/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityConfigMap
extends AbstractConfigMapImpl<Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityConfigMap.class);
    @Deprecated
    private EntityInternal entity;

    public EntityConfigMap(EntityInternal entity) {
        super((BrooklynObject)Preconditions.checkNotNull((Object)entity, (Object)"entity must be specified"));
    }

    public EntityConfigMap(EntityInternal entity, Map<ConfigKey<?>, Object> storage) {
        super((BrooklynObject)Preconditions.checkNotNull((Object)entity, (Object)"entity must be specified"), (Map)Preconditions.checkNotNull(storage, (Object)"storage map must be specified"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityInternal getContainer() {
        Entity result = (Entity)super.getContainer();
        if (result != null) {
            return (EntityInternal)result;
        }
        EntityConfigMap entityConfigMap = this;
        synchronized (entityConfigMap) {
            result = (Entity)super.getContainer();
            if (result != null) {
                return (EntityInternal)result;
            }
            this.bo = this.entity;
            this.entity = null;
        }
        return (EntityInternal)super.getBrooklynObject();
    }

    @Override
    public <T> void assertValid(ConfigKey<T> key, T val) {
        ConfigConstraints.assertValid((Entity)this.getContainer(), key, val);
    }

    protected EntityInternal getEntity() {
        return (EntityInternal)this.getBrooklynObject();
    }

    @Override
    protected ExecutionContext getExecutionContext(BrooklynObject bo) {
        return ((EntityInternal)bo).getExecutionContext();
    }

    @Override
    protected void postSetConfig() {
        this.getEntity().config().refreshInheritedConfigOfChildren();
    }

    @Override
    protected void postLocalEvaluate(ConfigKey<?> key, BrooklynObject bo, Maybe<?> rawValue, Maybe<?> resolvedValue) {
        if (rawValue.isPresent() && rawValue.get() instanceof Task) {
            ((EntityInternal)bo).getManagementSupport().getEntityChangeListener().onConfigChanged(key);
        }
    }

    @Override
    protected Entity getParentOfContainer(Entity container) {
        if (container == null) {
            return null;
        }
        return container.getParent();
    }

    @Override
    protected <T> ConfigKey<?> getKeyAtContainerImpl(Entity container, ConfigKey<T> queryKey) {
        if (queryKey == null) {
            return null;
        }
        return container.getEntityType().getConfigKey(queryKey.getName());
    }

    @Override
    protected Set<ConfigKey<?>> getKeysAtContainer(Entity container) {
        return container.getEntityType().getConfigKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public EntityConfigMap submap(Predicate<ConfigKey<?>> filter) {
        EntityConfigMap m = new EntityConfigMap(this.getEntity(), (Map<ConfigKey<?>, Object>)Maps.newLinkedHashMap());
        Map map = this.ownConfig;
        synchronized (map) {
            for (Map.Entry entry : this.ownConfig.entrySet()) {
                if (!filter.apply(entry.getKey())) continue;
                m.ownConfig.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.getEntity().getParent() != null) {
            this.merge(m, ((EntityConfigMap)((BrooklynObjectInternal.ConfigurationSupportInternal)this.getEntity().getParent().config()).getInternalConfigMap()).submap(filter));
        }
        return m;
    }

    @Deprecated
    private void merge(EntityConfigMap local, EntityConfigMap parent) {
        for (ConfigKey k : parent.ownConfig.keySet()) {
            if (local.ownConfig.containsKey(k)) continue;
            local.ownConfig.put(k, parent.ownConfig.get(k));
        }
    }
}

