/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;

public class QuotedStringTokenizer {
    final StringTokenizer delegate;
    final String quoteChars;
    final boolean includeQuotes;
    final String delimiters;
    final boolean includeDelimiters;
    final boolean expectQuotesDelimited;
    final boolean failOnOpenQuote;
    public static String DEFAULT_QUOTE_CHARS = "\"'";
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    String peekedNextToken = null;

    protected String DEFAULT_QUOTE_CHARS() {
        return DEFAULT_QUOTE_CHARS;
    }

    public QuotedStringTokenizer(String stringToTokenize) {
        this(stringToTokenize, true);
    }

    public QuotedStringTokenizer(String stringToTokenize, boolean includeQuotes) {
        this(stringToTokenize, null, includeQuotes);
    }

    public QuotedStringTokenizer(String stringToTokenize, String quoteChars, boolean includeQuotes) {
        this(stringToTokenize, quoteChars, includeQuotes, null, false);
    }

    public QuotedStringTokenizer(String stringToTokenize, String quoteChars, boolean includeQuotes, String delimiters, boolean includeDelimiters) {
        this(stringToTokenize, quoteChars, includeQuotes, delimiters, includeDelimiters, false, false);
    }

    public QuotedStringTokenizer(String stringToTokenize, String quoteChars, boolean includeQuotes, String delimiters, boolean includeDelimiters, boolean expectQuotesDelimited, boolean failOnOpenQuote) {
        this.delegate = new StringTokenizer(stringToTokenize == null ? "" : stringToTokenize, delimiters == null ? DEFAULT_DELIMITERS : delimiters, true);
        this.quoteChars = quoteChars == null ? this.DEFAULT_QUOTE_CHARS() : quoteChars;
        this.includeQuotes = includeQuotes;
        this.delimiters = delimiters == null ? DEFAULT_DELIMITERS : delimiters;
        this.includeDelimiters = includeDelimiters;
        this.expectQuotesDelimited = expectQuotesDelimited;
        this.failOnOpenQuote = failOnOpenQuote;
        this.updateNextToken();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<String> parseWithQuotesAnywhere(String s) {
        return QuotedStringTokenizer.builder().expectQuotesDelimited(false).buildList(s);
    }

    public static List<String> parseWithDelimitedQuotesOnly(String s) {
        return QuotedStringTokenizer.builder().expectQuotesDelimited(true).buildList(s);
    }

    public static List<String> parseAsStreamTokenizerIdentifierStrings(String s) {
        try {
            StringReader reader = new StringReader(s);
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            return QuotedStringTokenizer.readAll(streamTokenizer);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    public static List<String> parseAsStreamTokenizerWhitespaceOrStrings(String s) {
        try {
            StringReader reader = new StringReader(s);
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            streamTokenizer.resetSyntax();
            streamTokenizer.pushBack();
            streamTokenizer.wordChars(0, 255);
            for (char c : DEFAULT_DELIMITERS.toCharArray()) {
                streamTokenizer.whitespaceChars(c, c);
            }
            for (char c : DEFAULT_QUOTE_CHARS.toCharArray()) {
                streamTokenizer.quoteChar(c);
            }
            return QuotedStringTokenizer.readAll(streamTokenizer);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    private static List<String> readAll(StreamTokenizer streamTokenizer) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        int currentToken = 0;
        currentToken = streamTokenizer.nextToken();
        while (currentToken != -1) {
            if (streamTokenizer.ttype == -2) {
                tokens.add("" + streamTokenizer.nval);
            } else if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 39 || streamTokenizer.ttype == 34) {
                tokens.add(streamTokenizer.sval);
            } else {
                tokens.add("" + (char)currentToken);
            }
            currentToken = streamTokenizer.nextToken();
        }
        return tokens;
    }

    public synchronized boolean hasMoreTokens() {
        return this.peekedNextToken != null;
    }

    public synchronized String nextToken() {
        if (this.peekedNextToken == null) {
            throw new NoSuchElementException();
        }
        String lastToken = this.peekedNextToken;
        this.updateNextToken();
        return this.includeQuotes ? lastToken : (this.expectQuotesDelimited ? this.unwrapIfQuoted(lastToken) : this.unquoteToken(lastToken));
    }

    public boolean isQuoted(String token) {
        int i;
        if (Strings.isBlank(token)) {
            return false;
        }
        if (!this.isQuoteChar((token = token.trim()).charAt(0))) {
            return false;
        }
        if (this.isUnterminatedQuotedPhrase(token)) {
            return false;
        }
        if (!token.endsWith("" + token.charAt(0))) {
            return false;
        }
        String quoteFreeRequired = token.substring(1, token.length() - 1);
        quoteFreeRequired = Strings.replaceAllRegex(quoteFreeRequired, "\\\\.", "");
        while ((i = quoteFreeRequired.indexOf("" + token.charAt(0))) != -1 && !(quoteFreeRequired = quoteFreeRequired.substring(i + 1)).isEmpty()) {
            if (this.delimiters.contains("" + quoteFreeRequired.charAt(0))) {
                return false;
            }
            if (!this.failOnOpenQuote) continue;
            throw new IllegalArgumentException("Mismatched inner quotes");
        }
        return true;
    }

    public String unwrapIfQuoted(String token) {
        if (this.isQuoted(token)) {
            token = token.substring(1, token.length() - 1);
            int i = 0;
            while ((i = token.indexOf(92, i)) >= 0) {
                if (token.length() > i + 1) {
                    token = token.substring(0, i) + this.unescapeChar(token.charAt(i + 1)) + token.substring(i + 2);
                }
                ++i;
            }
        }
        return token;
    }

    protected char unescapeChar(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                return c;
            }
            case 'n': {
                return '\n';
            }
        }
        throw new IllegalArgumentException("Unsupported escape sequence \\" + c);
    }

    public String unquoteToken(String word) {
        word = word.replaceAll("((\\A|[^\\\\])(\\\\\\\\)*)[" + this.quoteChars + "]+", "$1");
        word = word.replaceAll("\\\\([\\\\" + this.quoteChars + "])", "$1");
        return word;
    }

    public String quoteToken(String unescapedText) {
        String result = unescapedText;
        result = result.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("([" + this.quoteChars + "])", "\\\\$1");
        result = this.quoteChars.charAt(0) + result + this.quoteChars.charAt(0);
        return result;
    }

    protected synchronized void updateNextToken() {
        String token;
        this.peekedNextToken = null;
        do {
            if (!this.delegate.hasMoreTokens()) {
                return;
            }
            token = this.delegate.nextToken();
        } while (!this.includeDelimiters && token.matches("[" + this.delimiters + "]+"));
        StringBuffer nextToken = new StringBuffer(token);
        this.pullUntilValid(nextToken);
        this.peekedNextToken = nextToken.toString();
    }

    private void pullUntilValid(StringBuffer nextToken) {
        while (this.isUnterminatedQuotedPhrase(nextToken.toString()) && this.delegate.hasMoreTokens()) {
            nextToken.append(this.delegate.nextToken());
        }
        if (this.failOnOpenQuote) {
            if (this.isUnterminatedQuotedPhrase(nextToken.toString())) {
                throw new IllegalArgumentException("Mismatched quotation marks in expression");
            }
            this.isQuoted(nextToken.toString());
        }
    }

    boolean isUnterminatedQuotedPhrase(String stringToCheck) {
        if (!this.expectQuotesDelimited) {
            return QuotedStringTokenizer.hasOpenQuote(stringToCheck, this.quoteChars);
        }
        if (stringToCheck.isEmpty()) {
            return false;
        }
        char start = stringToCheck.charAt(0);
        if (!this.isQuoteChar(start)) {
            return false;
        }
        int end = stringToCheck.length() - 1;
        if (end == 0) {
            return true;
        }
        char last = stringToCheck.charAt(end);
        if (!this.isQuoteChar(last)) {
            return true;
        }
        int numBackslashes = 0;
        while (stringToCheck.charAt(--end) == '\\') {
            ++numBackslashes;
        }
        return numBackslashes % 2 == 1;
    }

    boolean isQuoteChar(char c) {
        return this.quoteChars.indexOf(c) >= 0;
    }

    public static boolean hasOpenQuote(String stringToCheck) {
        return QuotedStringTokenizer.hasOpenQuote(stringToCheck, DEFAULT_QUOTE_CHARS);
    }

    public static boolean hasOpenQuote(String stringToCheck, String quoteChars) {
        String x = stringToCheck;
        if (x == null) {
            return false;
        }
        StringBuffer xi = new StringBuffer();
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (quoteChars.indexOf(c) < 0) continue;
            xi.append(c);
        }
        x = xi.toString();
        while (x.length() > 0) {
            char c = x.charAt(0);
            int match = x.indexOf(c, 1);
            if (match == -1) {
                return true;
            }
            x = x.substring(match + 1);
        }
        return false;
    }

    public List<String> remainderAsList() {
        ArrayList<String> l = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            l.add(this.nextToken());
        }
        this.peekedNextToken = null;
        return l;
    }

    public List<String> remainderRaw() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.peekedNextToken != null) {
            l.add(this.peekedNextToken);
        }
        while (this.delegate.hasMoreTokens()) {
            l.add(this.delegate.nextToken());
        }
        this.peekedNextToken = null;
        return l;
    }

    public static class Builder {
        private String quoteChars = DEFAULT_QUOTE_CHARS;
        private boolean includeQuotes = true;
        private String delimiterChars = " \t\n\r\f";
        private boolean includeDelimiters = false;
        private boolean expectQuotesDelimited = false;
        private boolean failOnOpenQuote = false;

        public QuotedStringTokenizer build(String stringToTokenize) {
            return new QuotedStringTokenizer(stringToTokenize, this.quoteChars, this.includeQuotes, this.delimiterChars, this.includeDelimiters, this.expectQuotesDelimited, this.failOnOpenQuote);
        }

        public List<String> buildList(String stringToTokenize) {
            return this.build(stringToTokenize).remainderAsList();
        }

        public Builder quoteChars(String quoteChars) {
            this.quoteChars = quoteChars;
            return this;
        }

        public Builder addQuoteChars(String quoteChars) {
            this.quoteChars = this.quoteChars + quoteChars;
            return this;
        }

        public Builder includeQuotes(boolean includeQuotes) {
            this.includeQuotes = includeQuotes;
            return this;
        }

        public Builder delimiterChars(String delimiterChars) {
            this.delimiterChars = delimiterChars;
            return this;
        }

        public Builder addDelimiterChars(String delimiterChars) {
            this.delimiterChars = this.delimiterChars + delimiterChars;
            return this;
        }

        public Builder includeDelimiters(boolean includeDelimiters) {
            this.includeDelimiters = includeDelimiters;
            return this;
        }

        public Builder keepInternalQuotes(boolean expectQuotesDelimited) {
            this.expectQuotesDelimited = expectQuotesDelimited;
            return this;
        }

        public Builder expectQuotesDelimited(boolean expectQuotesDelimited) {
            this.expectQuotesDelimited = expectQuotesDelimited;
            return this;
        }

        public Builder failOnOpenQuote(boolean failOnOpenQuote) {
            this.failOnOpenQuote = failOnOpenQuote;
            return this;
        }
    }
}

