/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.catalog;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.Rebindable;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;

@Beta
public interface CatalogItem<T, SpecT>
extends BrooklynObject,
Rebindable {
    @Override
    public Configurable.ConfigurationSupport config();

    @Override
    public BrooklynObject.SubscriptionSupport subscriptions();

    public CatalogItemType getCatalogItemType();

    public Class<T> getCatalogItemJavaType();

    public Class<SpecT> getSpecType();

    @Deprecated
    @Nullable
    public String getJavaType();

    @Nullable
    public String getDescription();

    @Nullable
    public String getIconUrl();

    public String getSymbolicName();

    public String getContainingBundle();

    public String getVersion();

    public Collection<CatalogBundle> getLibraries();

    @Nullable
    public String getPlanYaml();

    public RebindSupport<CatalogItemMemento> getRebindSupport();

    @Override
    public String getCatalogItemId();

    public void setDeprecated(boolean var1);

    public void setDisabled(boolean var1);

    public boolean isDeprecated();

    public boolean isDisabled();

    @Deprecated
    public static interface CatalogItemLibraries {
        public Collection<String> getBundles();
    }

    public static interface CatalogBundle
    extends OsgiBundleWithUrl {
    }

    public static enum CatalogItemType {
        TEMPLATE,
        APPLICATION,
        ENTITY,
        POLICY,
        ENRICHER,
        LOCATION,
        BEAN;


        public static CatalogItemType ofSpecClass(Class<? extends AbstractBrooklynObjectSpec<?, ?>> type) {
            if (type == null) {
                return null;
            }
            if (PolicySpec.class.isAssignableFrom(type)) {
                return POLICY;
            }
            if (EnricherSpec.class.isAssignableFrom(type)) {
                return ENRICHER;
            }
            if (LocationSpec.class.isAssignableFrom(type)) {
                return LOCATION;
            }
            if (EntitySpec.class.isAssignableFrom(type)) {
                return ENTITY;
            }
            return null;
        }

        public static CatalogItemType ofTargetClass(Class<? extends BrooklynObject> type) {
            if (type == null) {
                return null;
            }
            if (Policy.class.isAssignableFrom(type)) {
                return POLICY;
            }
            if (Enricher.class.isAssignableFrom(type)) {
                return ENRICHER;
            }
            if (Location.class.isAssignableFrom(type)) {
                return LOCATION;
            }
            if (Application.class.isAssignableFrom(type)) {
                return APPLICATION;
            }
            if (Entity.class.isAssignableFrom(type)) {
                return ENTITY;
            }
            return null;
        }

        public BrooklynObjectType getBrooklynObjectType() {
            return BrooklynObjectType.of(this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

