/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import org.jclouds.azurecompute.arm.domain.AutoValue_InboundNatRuleProperties;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class InboundNatRuleProperties
implements Provisionable {
    @Nullable
    public abstract IdReference frontendIPConfiguration();

    @Nullable
    public abstract IdReference backendIPConfiguration();

    public abstract Protocol protocol();

    public abstract int backendPort();

    public abstract int frontendPort();

    @Nullable
    public abstract Boolean enableFloatingIP();

    @Nullable
    public abstract Integer idleTimeoutInMinutes();

    @Override
    @Nullable
    public abstract String provisioningState();

    @SerializedNames(value={"frontendIPConfiguration", "backendIPConfiguration", "protocol", "frontendPort", "backendPort", "provisioningState", "enableFloatingIP", "idleTimeoutInMinutes"})
    public static InboundNatRuleProperties create(IdReference frontendIPConfiguration, IdReference backendIPConfiguration, Protocol protocol, int frontendPort, int backendPort, String provisioningState, Boolean enableFloatingIP, Integer idleTimeoutInMinutes) {
        return InboundNatRuleProperties.builder().frontendIPConfiguration(frontendIPConfiguration).backendIPConfiguration(backendIPConfiguration).protocol(protocol).frontendPort(frontendPort).backendPort(backendPort).provisioningState(provisioningState).enableFloatingIP(enableFloatingIP).idleTimeoutInMinutes(idleTimeoutInMinutes).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_InboundNatRuleProperties.Builder();
    }

    public static abstract class Builder {
        public abstract Builder frontendIPConfiguration(IdReference var1);

        public abstract Builder backendIPConfiguration(IdReference var1);

        public abstract Builder protocol(Protocol var1);

        public abstract Builder frontendPort(int var1);

        public abstract Builder backendPort(int var1);

        public abstract Builder provisioningState(String var1);

        public abstract Builder enableFloatingIP(Boolean var1);

        public abstract Builder idleTimeoutInMinutes(Integer var1);

        public abstract InboundNatRuleProperties build();
    }

    public static enum Protocol {
        Tcp("Tcp"),
        Udp("Udp"),
        UNRECOGNIZED("Unrecognized");

        private final String label;

        private Protocol(String label) {
            this.label = label;
        }

        public static Protocol fromValue(String text) {
            return (Protocol)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return this.label;
        }
    }
}

