/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import com.google.common.annotations.Beta;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.error.YAMLException;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    static Set<Class<?>> encounteredUnknownExceptions = MutableSet.of();
    static Set<Object> encounteredExceptionRecords = MutableSet.of();

    public Response toResponse(Throwable throwable1) {
        UserFacingException userFacing;
        if (throwable1.getClass().getName().equals("org.eclipse.jetty.io.EofException")) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("REST request running as {} was disconnected, threw: {}", (Object)Entitlements.getEntitlementContext(), (Object)Exceptions.collapseText((Throwable)throwable1));
            }
            return null;
        }
        Throwable throwable2 = Exceptions.getFirstInteresting((Throwable)throwable1);
        if (this.isSevere(throwable2)) {
            LOG.warn("REST request running as {} threw: {}", (Object)Entitlements.getEntitlementContext(), (Object)Exceptions.collapseText((Throwable)throwable1));
        } else {
            LOG.debug("REST request running as {} threw: {}", (Object)Entitlements.getEntitlementContext(), (Object)Exceptions.collapseText((Throwable)throwable1));
        }
        DefaultExceptionMapper.logExceptionDetailsForDebugging(throwable1);
        if (throwable2 instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)throwable2;
            return wae.getResponse();
        }
        if (throwable2 instanceof UserFacingException) {
            return ApiError.of((String)throwable2.getMessage()).asBadRequestResponseJson();
        }
        if (throwable2 instanceof ClassCoercionException || throwable2 instanceof IllegalArgumentException) {
            return ApiError.of((Throwable)throwable2).asBadRequestResponseJson();
        }
        if (throwable2 instanceof YAMLException) {
            return ApiError.builder().message(throwable2.getMessage()).prefixMessage("Invalid YAML").build().asBadRequestResponseJson();
        }
        if (!this.isTooUninterestingToLogWarn(throwable2) && encounteredUnknownExceptions.add(throwable2.getClass())) {
            LOG.warn("REST call generated exception type " + throwable2.getClass() + " unrecognized in " + this.getClass() + " (subsequent occurrences will be logged debug only): " + throwable2, throwable2);
        }
        if ((userFacing = (UserFacingException)Exceptions.getFirstThrowableOfType((Throwable)throwable1, UserFacingException.class)) instanceof UserFacingException) {
            return ApiError.of((String)userFacing.getMessage()).asBadRequestResponseJson();
        }
        ApiError.Builder rb = ApiError.builderFromThrowable((Throwable)Exceptions.collapse((Throwable)throwable2));
        if (Strings.isBlank((CharSequence)rb.getMessage())) {
            rb.message("Internal error. Contact server administrator to consult logs for more details.");
        }
        return rb.build().asResponse(Response.Status.INTERNAL_SERVER_ERROR, MediaType.APPLICATION_JSON_TYPE);
    }

    protected boolean isTooUninterestingToLogWarn(Throwable throwable2) {
        return false;
    }

    @Beta
    public static void logExceptionDetailsForDebugging(Throwable t) {
        if (LOG.isDebugEnabled()) {
            if (DefaultExceptionMapper.firstEncounter(t)) {
                LOG.debug("Full details of " + Entitlements.getEntitlementContext() + " " + t + " (logging debug on first encounter; subsequent instances will be logged trace)", t);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Full details of " + Entitlements.getEntitlementContext() + " " + t, t);
            }
        }
    }

    private static boolean firstEncounter(Throwable t) {
        MutableSet record = MutableSet.of();
        do {
            record.add(t.getClass());
        } while ((t.getStackTrace().length <= 0 || !record.add(t.getStackTrace()[0])) && (t = t.getCause()) != null);
        return encounteredExceptionRecords.add(record);
    }

    protected boolean isSevere(Throwable t) {
        return t instanceof OutOfMemoryError;
    }
}

