/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class HaHotCheckHelperAbstract {
    private static final Logger log = LoggerFactory.getLogger(HaHotCheckHelperAbstract.class);
    public static final String SKIP_CHECK_HEADER = "Brooklyn-Allow-Non-Master-Access";
    private static final Set<ManagementNodeState> HOT_STATES = ImmutableSet.of((Object)ManagementNodeState.MASTER, (Object)ManagementNodeState.HOT_STANDBY, (Object)ManagementNodeState.HOT_BACKUP);

    public static Maybe<String> getProblemMessageIfServerNotRunning(ManagementContext mgmt) {
        if (mgmt == null) {
            return Maybe.of((Object)"no management context available");
        }
        if (!mgmt.isRunning()) {
            return Maybe.of((Object)"server no longer running");
        }
        if (!mgmt.isStartupComplete()) {
            return Maybe.of((Object)"server not in required startup-completed state");
        }
        return Maybe.absent();
    }

    public Maybe<String> getProblemMessageIfServerNotRunning() {
        return HaHotCheckHelperAbstract.getProblemMessageIfServerNotRunning(this.mgmt());
    }

    public Response disallowResponse(String problem, Object info) {
        return this.disallowResponse(problem, info, true);
    }

    public Response disallowResponse(String problem, Object info, boolean masterRequired) {
        log.warn("Disallowing web request as " + problem + ": " + info + " (caller should set '" + SKIP_CHECK_HEADER + "' to force)");
        return ApiError.builder().message("This request is only permitted against an active " + (masterRequired ? "primary" : "primary or hot standby/backup") + " Brooklyn server").errorCode(Response.Status.FORBIDDEN).build().asJsonResponse();
    }

    public boolean isSkipCheckHeaderSet(String headerValueString) {
        return "true".equalsIgnoreCase(headerValueString);
    }

    public boolean isHaHotStatus() {
        ManagementNodeState state = this.mgmt().getHighAvailabilityManager().getNodeState();
        return HOT_STATES.contains(state);
    }

    public abstract ManagementContext mgmt();

    public boolean isStateNotYetValid() {
        return this.mgmt().getRebindManager().isAwaitingInitialRebind();
    }

    public static boolean isCallAllowedInAnyState(String uri) {
        if (uri != null) {
            if ((uri = Strings.removeAllFromStart((String)uri, (String[])new String[]{"/", "v1/"})).startsWith("logout")) {
                return true;
            }
            if ("server/shutdown".equals(uri)) {
                return true;
            }
        }
        return false;
    }
}

