/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.resolve;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.resolve.entity.AbstractEntitySpecResolver;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.group.DynamicRegionsFabric;
import org.apache.brooklyn.entity.java.VanillaJavaApp;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcess;
import org.apache.brooklyn.util.core.ClassLoaderUtils;

public class HardcodedCatalogEntitySpecResolver
extends AbstractEntitySpecResolver {
    private static final String RESOLVER_NAME = "catalog";
    private static final Map<String, Class<? extends Entity>> CATALOG_CLASS_TYPES = ImmutableMap.builder().put((Object)"cluster", DynamicCluster.class).put((Object)"fabric", DynamicRegionsFabric.class).put((Object)"vanilla", VanillaSoftwareProcess.class).put((Object)"software-process", VanillaSoftwareProcess.class).put((Object)"java-app", VanillaJavaApp.class).put((Object)"brooklyn-node", BrooklynNode.class).build();
    private static final Map<String, String> CATALOG_STRING_TYPES = ImmutableMap.builder().put((Object)"web-app-cluster", (Object)("org.apache.brooklyn.software-webapp:" + BrooklynVersion.get() + ":org.apache.brooklyn.entity.webapp.ControlledDynamicWebAppCluster")).build();
    private static final Converter<String, String> FMT = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN);

    public HardcodedCatalogEntitySpecResolver() {
        super(RESOLVER_NAME);
    }

    protected boolean canResolve(String type, BrooklynClassLoadingContext loader) {
        String localType = this.getLocalType(type);
        return this.getImplementation(CATALOG_CLASS_TYPES, localType) != null || this.getImplementation(CATALOG_STRING_TYPES, localType) != null;
    }

    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        String localType = this.getLocalType(type);
        Class<? extends Entity> specClassType = this.getImplementation(CATALOG_CLASS_TYPES, localType);
        if (specClassType != null) {
            return this.buildSpec(specClassType);
        }
        String specStringType = this.getImplementation(CATALOG_STRING_TYPES, localType);
        if (specStringType != null) {
            return this.buildSpec(specStringType);
        }
        return null;
    }

    private <T> T getImplementation(Map<String, T> types, String type) {
        T specType = types.get(type);
        if (specType != null) {
            return specType;
        }
        return types.get(FMT.convert((Object)type));
    }

    private EntitySpec<?> buildSpec(String specTypName) {
        try {
            Class specType = new ClassLoaderUtils(((Object)((Object)this)).getClass()).loadClass(specTypName);
            return this.buildSpec(specType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load hardcoded catalog type " + specTypName, e);
        }
    }

    protected EntitySpec<?> buildSpec(Class<?> specType) {
        Class<?> specClass = specType;
        return EntitySpec.create(specClass);
    }
}

