/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.storm;

import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessDriver;
import org.apache.brooklyn.entity.messaging.storm.Storm;
import org.apache.brooklyn.entity.messaging.storm.StormDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormImpl
extends SoftwareProcessImpl
implements Storm {
    private static final Logger log = LoggerFactory.getLogger(StormImpl.class);
    public static final ObjectName STORM_MBEAN = JmxHelper.createObjectName((String)"backtype.storm.daemon.nimbus:type=*");
    private JmxHelper jmxHelper;
    private volatile JmxFeed jmxFeed;

    @Override
    public String getHostname() {
        return (String)this.getAttribute(HOSTNAME);
    }

    @Override
    public Storm.Role getRole() {
        return (Storm.Role)((Object)this.getConfig(ROLE));
    }

    @Override
    public String getStormConfigTemplateUrl() {
        return (String)this.getConfig(STORM_CONFIG_TEMPLATE_URL);
    }

    public Class<?> getDriverInterface() {
        return StormDriver.class;
    }

    public String getRoleName() {
        return this.getRole().name().toLowerCase();
    }

    protected void preStart() {
        this.setDefaultDisplayName("Storm Node (" + this.getRoleName() + ")");
        super.preStart();
    }

    protected void connectSensors() {
        super.connectSensors();
        Time.sleep((Duration)Duration.TEN_SECONDS);
        if (this.getRole() == Storm.Role.UI) {
            this.sensors().set(STORM_UI_URL, (Object)("http://" + (String)this.getAttribute(Attributes.HOSTNAME) + ":" + this.getAttribute((AttributeSensor)UI_PORT) + "/"));
        }
        if (((JavaSoftwareProcessDriver)this.getDriver()).isJmxEnabled()) {
            this.jmxHelper = new JmxHelper((Entity)this);
            this.jmxFeed = JavaAppUtils.connectMXBeanSensors((Entity)this);
            this.connectServiceUpIsRunning();
        } else {
            log.warn("Storm running without JMX monitoring; limited visibility of service available");
            this.connectServiceUpIsRunning();
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
        if (this.jmxHelper != null) {
            this.jmxHelper.terminate();
        }
    }
}

