/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.util;

import java.util.Arrays;

public final class StdStreamData {
    private final StdStreamType type;
    private final byte[] payload;
    private final boolean truncated;

    StdStreamData(byte streamTypeId, byte[] payload, boolean truncated) throws ArrayIndexOutOfBoundsException, NullPointerException {
        this.type = StdStreamType.values()[streamTypeId];
        this.payload = Arrays.copyOf(payload, payload.length);
        this.truncated = truncated;
    }

    public StdStreamType getType() {
        return this.type;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static enum StdStreamType {
        IN,
        OUT,
        ERR;

    }
}

