/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.loadbalancer;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.LoadBalancer;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;
import org.jclouds.profitbricks.http.parser.firewall.FirewallListResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerListResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseLoadBalancerResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected final ServerListResponseHandler balancedServerResponseHandler;
    protected final FirewallListResponseHandler firewallListResponseHandler;
    protected LoadBalancer.Builder builder;
    protected DataCenter.Builder dataCenterBuilder;
    protected final DateService dateService;
    protected boolean useBalancedServerParser = false;
    protected boolean useFirewallParser = false;

    protected BaseLoadBalancerResponseHandler(DateService dateService, ServerListResponseHandler balancedServerResponseHandler, FirewallListResponseHandler firewallResponseHandler) {
        Preconditions.checkNotNull((Object)dateService, (Object)"DateService cannot be null");
        Preconditions.checkNotNull((Object)((Object)balancedServerResponseHandler), (Object)"BalancedServerResponseHandler cannot be null");
        Preconditions.checkNotNull((Object)((Object)firewallResponseHandler), (Object)"FirewallListResponseHandler cannot be null");
        this.dateService = dateService;
        this.builder = LoadBalancer.builder();
        this.dataCenterBuilder = DataCenter.builder();
        this.balancedServerResponseHandler = balancedServerResponseHandler;
        this.firewallListResponseHandler = firewallResponseHandler;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("balancedServers".equals(qName)) {
            this.useBalancedServerParser = true;
        }
        if ("firewall".equals(qName)) {
            this.useFirewallParser = true;
        }
        if (this.useBalancedServerParser) {
            this.balancedServerResponseHandler.startElement(uri, localName, qName, attributes);
        } else if (this.useFirewallParser) {
            this.firewallListResponseHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.useBalancedServerParser) {
            this.balancedServerResponseHandler.characters(ch, start, length);
        } else if (this.useFirewallParser) {
            this.firewallListResponseHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    protected final Date textToIso8601Date() {
        return this.dateService.iso8601DateOrSecondsDateParse(this.textToStringValue());
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("loadBalancerId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("loadBalancerName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("loadBalancerAlgorithm".equals(qName)) {
            this.builder.algorithm(LoadBalancer.Algorithm.fromValue(this.textToStringValue()));
        } else if ("dataCenterId".equals(qName)) {
            this.dataCenterBuilder.id(this.textToStringValue());
        } else if ("dataCenterVersion".equals(qName)) {
            this.dataCenterBuilder.version(this.textToIntValue());
        } else if ("internetAccess".equals(qName)) {
            this.builder.internetAccess(this.textToBooleanValue());
        } else if ("ip".equals(qName)) {
            this.builder.ip(this.textToStringValue());
        } else if ("lanId".equals(qName)) {
            this.builder.lanId(this.textToIntValue());
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        } else if ("creationTime".equals(qName)) {
            this.builder.creationTime(this.textToIso8601Date());
        } else if ("lastModificationTime".equals(qName)) {
            this.builder.lastModificationTime(this.textToIso8601Date());
        }
    }
}

