/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ssh;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallRSAPrivateKey
implements Statement {
    private final String sshDir;
    private final String privateKey;

    public InstallRSAPrivateKey(String privateKey) {
        this("~/.ssh", privateKey);
    }

    public InstallRSAPrivateKey(String sshDir, String privateKey) {
        this.sshDir = (String)Preconditions.checkNotNull((Object)sshDir, (Object)"sshDir");
        this.privateKey = (String)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey");
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull((Object)((Object)family), (Object)"family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add((Object)Statements.exec("{md} " + this.sshDir));
        String idRsa = this.sshDir + "{fs}id_rsa";
        statements.add((Object)Statements.exec("{rm} " + idRsa));
        statements.add((Object)Statements.appendFile(idRsa, Splitter.on((char)'\n').split((CharSequence)this.privateKey)));
        statements.add((Object)Statements.exec("chmod 600 " + idRsa));
        return new StatementList((Iterable<Statement>)statements.build()).render(family);
    }
}

