/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.entity.kubernetes;

import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.entity.kubernetes.KubernetesPod;
import org.apache.brooklyn.container.entity.kubernetes.KubernetesResourceImpl;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.ResourcePredicates;

@ImplementedBy(value=KubernetesResourceImpl.class)
public interface KubernetesResource
extends SoftwareProcess {
    public static final ConfigKey<String> RESOURCE_FILE = ConfigKeys.builder(String.class).name("resource").description("Kubernetes resource YAML file URI").constraint(ResourcePredicates.urlExists()).build();
    public static final AttributeSensor<String> RESOURCE_TYPE = Sensors.builder(String.class, (String)"kubernetes.resource.type").description("Kubernetes resource type").build();
    public static final AttributeSensor<String> RESOURCE_NAME = Sensors.builder(String.class, (String)"kubernetes.resource.name").description("Kubernetes resource name").build();
    public static final AttributeSensor<String> KUBERNETES_NAMESPACE = KubernetesPod.KUBERNETES_NAMESPACE;
    public static final String POD = "Pod";
    public static final String DEPLOYMENT = "Deployment";
    public static final String REPLICA_SET = "ReplicaSet";
    public static final String CONFIG_MAP = "ConfigMap";
    public static final String PERSISTENT_VOLUME = "PersistentVolume";
    public static final String SECRET = "Secret";
    public static final String SERVICE = "Service";
    public static final String REPLICATION_CONTROLLER = "ReplicationController";
    public static final String NAMESPACE = "Namespace";
}

