/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.classloading;

import java.net.URL;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.util.guava.Maybe;

public class ClassLoaderFromBrooklynClassLoadingContext
extends ClassLoader {
    protected final BrooklynClassLoadingContext clc;

    public static ClassLoader of(BrooklynClassLoadingContext clc) {
        return new ClassLoaderFromBrooklynClassLoadingContext(clc);
    }

    protected ClassLoaderFromBrooklynClassLoadingContext(BrooklynClassLoadingContext clc) {
        this.clc = clc;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> result2;
        Maybe result = this.clc.tryLoadClass(className);
        if (result.isPresent()) {
            return (Class)result.get();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && (result2 = contextClassLoader.loadClass(className)) != null) {
            return result2;
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        URL result = this.clc.getResource(name);
        if (result != null) {
            return result;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && (result = contextClassLoader.getResource(name)) != null) {
            return result;
        }
        return null;
    }
}

