/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.tasks.kubectl;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.external.SshWorkflowStep;
import org.apache.brooklyn.tasks.kubectl.ContainerCommons;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskFactory;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskResult;
import org.apache.brooklyn.tasks.kubectl.PullPolicy;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.lang3.ObjectUtils;

public class ContainerWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "${image} [ ${command} ]";
    public static final ConfigKey<String> IMAGE = ConfigKeys.newStringConfigKey((String)"image");
    public static final ConfigKey<String> COMMAND = ConfigKeys.newStringConfigKey((String)"command");
    public static final ConfigKey<Object> ARGS = ConfigKeys.newConfigKey(Object.class, (String)"args", (String)"Arguments as a string, split into words respecting quoted phrases, or as a list of strings");
    public static final ConfigKey<List<String>> COMMANDS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"commands");
    public static final ConfigKey<List<String>> RAW_COMMAND = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"raw_command");
    public static final ConfigKey<PullPolicy> PULL_POLICY = ConfigKeys.newConfigKey(PullPolicy.class, (String)"pull_policy", (String)ContainerCommons.CONTAINER_IMAGE_PULL_POLICY.getDescription(), (Object)ContainerCommons.CONTAINER_IMAGE_PULL_POLICY.getDefaultValue());
    public static final ConfigKey<PullPolicy> PULL_POLICY_ALT = ConfigKeys.newConfigKey(PullPolicy.class, (String)"pull-policy", (String)ContainerCommons.CONTAINER_IMAGE_PULL_POLICY.getDescription(), (Object)ContainerCommons.CONTAINER_IMAGE_PULL_POLICY.getDefaultValue());
    public static final ConfigKey<Map<String, Object>> ENV = new MapConfigKey.Builder(Object.class, "env").build();
    public static final ConfigKey<DslPredicates.DslPredicate<Integer>> EXIT_CODE = ConfigKeys.newConfigKey((TypeToken)new TypeToken<DslPredicates.DslPredicate<Integer>>(){}, (String)"exit_code");
    public static final ConfigKey<Integer> OUTPUT_MAX_SIZE = ConfigKeys.newIntegerConfigKey((String)"output_max_size", (String)"Maximum size for stdout and stderr, or -1 for no limit", (Integer)100000);

    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        List rawCommand;
        List commands;
        String image = (String)context.getInput(IMAGE);
        if (Strings.isBlank((CharSequence)image)) {
            throw new IllegalStateException("'image' is required");
        }
        DslPredicates.DslPredicate exitcode = (DslPredicates.DslPredicate)context.getInput(EXIT_CODE);
        ContainerTaskFactory.ConcreteContainerTaskFactory tf = (ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)ContainerTaskFactory.newInstance().summary(image + " container task for workflow")).jobIdentifier(context.getWorkflowStepReference())).imagePullPolicy((PullPolicy)((Object)ObjectUtils.firstNonNull((Object[])new PullPolicy[]{(PullPolicy)((Object)context.getInput(PULL_POLICY)), (PullPolicy)((Object)context.getInput(PULL_POLICY_ALT))})))).image(image);
        MutableList commandTypesSet = MutableList.of();
        String command = (String)context.getInput(COMMAND);
        if (Strings.isNonBlank((CharSequence)command)) {
            commandTypesSet.add(COMMAND.getName());
            tf.bashScriptCommands(Arrays.asList(command));
        }
        if ((commands = (List)context.getInput(COMMANDS)) != null && !commands.isEmpty()) {
            commandTypesSet.add(COMMANDS.getName());
            tf.bashScriptCommands(commands);
        }
        if ((rawCommand = (List)context.getInput(RAW_COMMAND)) != null && !rawCommand.isEmpty()) {
            commandTypesSet.add(RAW_COMMAND.getName());
            tf.command(rawCommand);
        }
        if (commandTypesSet.size() > 1) {
            throw new IllegalStateException("Incompatible command specification, max 1, received: " + commandTypesSet);
        }
        Object args = context.getInput(ARGS);
        if (args instanceof String && Strings.isNonBlank((CharSequence)((String)args))) {
            tf.arguments(QuotedStringTokenizer.builder().includeQuotes(false).keepInternalQuotes(true).buildList((String)args));
        } else if (args instanceof Collection) {
            MutableList result = MutableList.of();
            ((Collection)args).forEach(arg_0 -> ContainerWorkflowStep.lambda$doTaskBody$0((List)result, arg_0));
            tf.arguments((List<String>)result);
        } else if (args != null) {
            throw new IllegalArgumentException("args must be a string or a list");
        }
        Map env = (Map)context.getInput(ENV);
        if (env != null) {
            tf.environmentVariables(new ShellEnvironmentSerializer(context.getWorkflowExectionContext().getManagementContext()).serialize(env));
        }
        if (exitcode != null) {
            tf.allowingNonZeroExitCode();
        }
        tf.returning(ptw -> {
            this.checkExitCode((ContainerTaskResult)ptw, (DslPredicates.DslPredicate<Integer>)exitcode);
            return MutableMap.of((Object)"stdout", (Object)SshWorkflowStep.truncate((String)ptw.getMainStdout(), (Integer)((Integer)context.getInput(OUTPUT_MAX_SIZE))), (Object)"exit_code", (Object)ptw.getMainExitCode());
        });
        return ((Task)DynamicTasks.queue(tf.newTask())).asTask().getUnchecked();
    }

    protected void checkExitCode(ContainerTaskResult ptw, DslPredicates.DslPredicate<Integer> exitcode) {
        Object implicit;
        if (exitcode == null) {
            return;
        }
        if (exitcode instanceof DslPredicates.DslPredicateBase && (implicit = ((DslPredicates.DslPredicateBase)exitcode).implicitEqualsUnwrapped()) != null && "any".equalsIgnoreCase("" + implicit)) {
            return;
        }
        if (!exitcode.apply((Object)ptw.getMainExitCode())) {
            throw new IllegalStateException("Invalid exit code '" + ptw.getMainExitCode() + "'");
        }
    }

    protected Boolean isDefaultIdempotent() {
        return false;
    }

    private static /* synthetic */ void lambda$doTaskBody$0(List result, Object x) {
        if (x instanceof String) {
            result.add((String)x);
        } else if (Boxing.isPrimitiveOrBoxedObject((Object)x)) {
            result.add(x.toString());
        } else {
            throw new IllegalArgumentException("Argument '" + x + "' not supported; should be a string");
        }
    }
}

