/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBSshDriver;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBDriver;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServerImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;

public class MongoDBSshDriver
extends AbstractMongoDBSshDriver
implements MongoDBDriver {
    public MongoDBSshDriver(MongoDBServerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public MongoDBServerImpl getEntity() {
        return (MongoDBServerImpl)MongoDBServerImpl.class.cast(super.getEntity());
    }

    public void launch() {
        MongoDBServerImpl server = this.getEntity();
        ImmutableList.Builder argsBuilder = this.getArgsBuilderWithDefaults(server).add((Object[])new String[]{"--dbpath", this.getDataDirectory()});
        if (server.isReplicaSetMember()) {
            String replicaSetName = server.getReplicaSet().getName();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)replicaSetName) ? 1 : 0) != 0, (Object)"Replica set name must not be null or empty");
            argsBuilder.add((Object[])new String[]{"--replSet", replicaSetName});
        }
        if (Boolean.TRUE.equals(server.getConfig(MongoDBServer.ENABLE_REST_INTERFACE))) {
            argsBuilder.add((Object)"--rest");
        }
        this.launch((ImmutableList.Builder<String>)argsBuilder);
    }
}

