/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.LocationConfigKeys;

public class EntityLocationUtils {
    protected final ManagementContext context;

    public EntityLocationUtils(ManagementContext ctx) {
        this.context = ctx;
    }

    public Map<Location, Integer> countLeafEntitiesByLocatedLocations() {
        LinkedHashMap<Location, Integer> result = new LinkedHashMap<Location, Integer>();
        for (Entity e : this.context.getApplications()) {
            this.countLeafEntitiesByLocatedLocations(e, null, result);
        }
        return result;
    }

    protected void countLeafEntitiesByLocatedLocations(Entity target, Entity locatedParent, Map<Location, Integer> result) {
        block6: {
            block5: {
                if (this.isLocatedLocation(target)) {
                    locatedParent = target;
                }
                if (target.getChildren().isEmpty()) break block5;
                for (Entity child : target.getChildren()) {
                    this.countLeafEntitiesByLocatedLocations(child, locatedParent, result);
                }
                break block6;
            }
            if (locatedParent == null) break block6;
            for (Location l : locatedParent.getLocations()) {
                Location ll = this.getMostGeneralLocatedLocation(l);
                if (ll == null) continue;
                Integer count = result.get(ll);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                result.put(ll, count);
            }
        }
    }

    protected Location getMostGeneralLocatedLocation(Location l) {
        if (l == null) {
            return null;
        }
        if (!this.isLocatedLocation(l)) {
            return null;
        }
        Location ll = this.getMostGeneralLocatedLocation(l.getParent());
        if (ll != null) {
            return ll;
        }
        return l;
    }

    protected boolean isLocatedLocation(Entity target) {
        for (Location l : target.getLocations()) {
            if (!this.isLocatedLocation(l)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLocatedLocation(Location l) {
        return l.getConfig(LocationConfigKeys.LATITUDE) != null && l.getConfig(LocationConfigKeys.LONGITUDE) != null;
    }
}

