/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.Objects;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.NaturalOrderComparator;

public class VersionComparator
implements Comparator<String> {
    public static final VersionComparator INSTANCE = new VersionComparator();

    public static VersionComparator getInstance() {
        return INSTANCE;
    }

    public static boolean isSnapshot(String version) {
        return BrooklynVersionSyntax.isSnapshot(version);
    }

    @Override
    public int compare(String v1, String v2) {
        int sep1;
        String u2;
        if (Objects.equal((Object)v1, (Object)v2)) {
            return 0;
        }
        TwoBooleans nulls = TwoBooleans.of(v1 == null, v2 == null);
        if (nulls.eitherTrue()) {
            return nulls.compare(true);
        }
        TwoBooleans snapshots = TwoBooleans.of(VersionComparator.isSnapshot(v1), VersionComparator.isSnapshot(v2));
        if (snapshots.different()) {
            return snapshots.compare(true);
        }
        String u1 = this.versionWithoutQualifier(v1);
        int uq = NaturalOrderComparator.INSTANCE.compare(u1, u2 = this.versionWithoutQualifier(v2));
        if (uq != 0) {
            return uq;
        }
        TwoBooleans no_qualifier = TwoBooleans.of(u1.equals(v1), u2.equals(v2));
        if (no_qualifier.different()) {
            return no_qualifier.compare(false);
        }
        String q1 = v1.substring(u1.length());
        String q2 = v2.substring(u2.length());
        String qq1 = q1;
        String qq2 = q2;
        if (q1.startsWith("-") || q1.startsWith(".") || q1.startsWith("_")) {
            q1 = q1.substring(1);
        }
        if (q2.startsWith("-") || q2.startsWith(".") || q2.startsWith("_")) {
            q2 = q2.substring(1);
        }
        if ((uq = NaturalOrderComparator.INSTANCE.compare(q1, q2)) != 0) {
            return uq;
        }
        int n = qq1.startsWith("-") ? 3 : (qq1.startsWith(".") ? 2 : (sep1 = qq1.startsWith("_") ? 1 : 0));
        int sep2 = qq2.startsWith("-") ? 3 : (qq2.startsWith(".") ? 2 : (qq2.startsWith("_") ? 1 : 0));
        uq = Integer.compare(sep1, sep2);
        if (uq != 0) {
            return uq;
        }
        return NaturalOrderComparator.INSTANCE.compare(v1, v2);
    }

    private String versionWithoutQualifier(String v1) {
        Matcher q = Pattern.compile("([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?)(.*)").matcher(v1);
        return q.matches() ? q.group(1) : "";
    }

    private static class TwoBooleans {
        private final boolean b1;
        private final boolean b2;

        public TwoBooleans(boolean b1, boolean b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        boolean bothTrue() {
            return this.b1 && this.b2;
        }

        boolean eitherTrue() {
            return this.b1 || this.b2;
        }

        boolean bothFalse() {
            return !this.eitherTrue();
        }

        boolean same() {
            return this.b1 == this.b2;
        }

        boolean different() {
            return this.b1 != this.b2;
        }

        int compare(boolean trueIsLess) {
            return this.same() ? 0 : (this.b1 == trueIsLess ? -1 : 1);
        }

        public static TwoBooleans of(boolean v1, boolean v2) {
            return new TwoBooleans(v1, v2);
        }
    }
}

