// File generated by specialize. Do not edit.

// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package optimized

import (
	"reflect"

	"github.com/apache/beam/sdks/v2/go/pkg/beam/core/typex"
	"github.com/apache/beam/sdks/v2/go/pkg/beam/core/util/reflectx"
)

// This template registers all forms of encoders as general
// reflectx.Func specializations for each X.

func init() {
	reflectx.RegisterFunc(reflect.TypeOf((*func(bool) []byte)(nil)).Elem(), encoderMakerBool)
	reflectx.RegisterFunc(reflect.TypeOf((*func(bool) ([]byte, error))(nil)).Elem(), encoderMakerBoolE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, bool) []byte)(nil)).Elem(), encoderMakerTBool)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, bool) ([]byte, error))(nil)).Elem(), encoderMakerTBoolE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(string) []byte)(nil)).Elem(), encoderMakerString)
	reflectx.RegisterFunc(reflect.TypeOf((*func(string) ([]byte, error))(nil)).Elem(), encoderMakerStringE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, string) []byte)(nil)).Elem(), encoderMakerTString)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, string) ([]byte, error))(nil)).Elem(), encoderMakerTStringE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int) []byte)(nil)).Elem(), encoderMakerInt)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int) ([]byte, error))(nil)).Elem(), encoderMakerIntE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int) []byte)(nil)).Elem(), encoderMakerTInt)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int) ([]byte, error))(nil)).Elem(), encoderMakerTIntE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int8) []byte)(nil)).Elem(), encoderMakerInt8)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int8) ([]byte, error))(nil)).Elem(), encoderMakerInt8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int8) []byte)(nil)).Elem(), encoderMakerTInt8)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int8) ([]byte, error))(nil)).Elem(), encoderMakerTInt8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int16) []byte)(nil)).Elem(), encoderMakerInt16)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int16) ([]byte, error))(nil)).Elem(), encoderMakerInt16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int16) []byte)(nil)).Elem(), encoderMakerTInt16)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int16) ([]byte, error))(nil)).Elem(), encoderMakerTInt16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int32) []byte)(nil)).Elem(), encoderMakerInt32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int32) ([]byte, error))(nil)).Elem(), encoderMakerInt32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int32) []byte)(nil)).Elem(), encoderMakerTInt32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int32) ([]byte, error))(nil)).Elem(), encoderMakerTInt32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int64) []byte)(nil)).Elem(), encoderMakerInt64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(int64) ([]byte, error))(nil)).Elem(), encoderMakerInt64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int64) []byte)(nil)).Elem(), encoderMakerTInt64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, int64) ([]byte, error))(nil)).Elem(), encoderMakerTInt64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint) []byte)(nil)).Elem(), encoderMakerUint)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint) ([]byte, error))(nil)).Elem(), encoderMakerUintE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint) []byte)(nil)).Elem(), encoderMakerTUint)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint) ([]byte, error))(nil)).Elem(), encoderMakerTUintE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint8) []byte)(nil)).Elem(), encoderMakerUint8)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint8) ([]byte, error))(nil)).Elem(), encoderMakerUint8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint8) []byte)(nil)).Elem(), encoderMakerTUint8)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint8) ([]byte, error))(nil)).Elem(), encoderMakerTUint8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint16) []byte)(nil)).Elem(), encoderMakerUint16)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint16) ([]byte, error))(nil)).Elem(), encoderMakerUint16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint16) []byte)(nil)).Elem(), encoderMakerTUint16)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint16) ([]byte, error))(nil)).Elem(), encoderMakerTUint16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint32) []byte)(nil)).Elem(), encoderMakerUint32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint32) ([]byte, error))(nil)).Elem(), encoderMakerUint32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint32) []byte)(nil)).Elem(), encoderMakerTUint32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint32) ([]byte, error))(nil)).Elem(), encoderMakerTUint32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint64) []byte)(nil)).Elem(), encoderMakerUint64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(uint64) ([]byte, error))(nil)).Elem(), encoderMakerUint64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint64) []byte)(nil)).Elem(), encoderMakerTUint64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, uint64) ([]byte, error))(nil)).Elem(), encoderMakerTUint64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(float32) []byte)(nil)).Elem(), encoderMakerFloat32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(float32) ([]byte, error))(nil)).Elem(), encoderMakerFloat32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, float32) []byte)(nil)).Elem(), encoderMakerTFloat32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, float32) ([]byte, error))(nil)).Elem(), encoderMakerTFloat32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(float64) []byte)(nil)).Elem(), encoderMakerFloat64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(float64) ([]byte, error))(nil)).Elem(), encoderMakerFloat64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, float64) []byte)(nil)).Elem(), encoderMakerTFloat64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, float64) ([]byte, error))(nil)).Elem(), encoderMakerTFloat64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.T) []byte)(nil)).Elem(), encoderMakerTypex_T)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.T) ([]byte, error))(nil)).Elem(), encoderMakerTypex_TE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.T) []byte)(nil)).Elem(), encoderMakerTTypex_T)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.T) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_TE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.U) []byte)(nil)).Elem(), encoderMakerTypex_U)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.U) ([]byte, error))(nil)).Elem(), encoderMakerTypex_UE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.U) []byte)(nil)).Elem(), encoderMakerTTypex_U)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.U) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_UE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.V) []byte)(nil)).Elem(), encoderMakerTypex_V)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.V) ([]byte, error))(nil)).Elem(), encoderMakerTypex_VE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.V) []byte)(nil)).Elem(), encoderMakerTTypex_V)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.V) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_VE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.W) []byte)(nil)).Elem(), encoderMakerTypex_W)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.W) ([]byte, error))(nil)).Elem(), encoderMakerTypex_WE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.W) []byte)(nil)).Elem(), encoderMakerTTypex_W)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.W) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_WE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.X) []byte)(nil)).Elem(), encoderMakerTypex_X)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.X) ([]byte, error))(nil)).Elem(), encoderMakerTypex_XE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.X) []byte)(nil)).Elem(), encoderMakerTTypex_X)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.X) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_XE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.Y) []byte)(nil)).Elem(), encoderMakerTypex_Y)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.Y) ([]byte, error))(nil)).Elem(), encoderMakerTypex_YE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.Y) []byte)(nil)).Elem(), encoderMakerTTypex_Y)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.Y) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_YE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.Z) []byte)(nil)).Elem(), encoderMakerTypex_Z)
	reflectx.RegisterFunc(reflect.TypeOf((*func(typex.Z) ([]byte, error))(nil)).Elem(), encoderMakerTypex_ZE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.Z) []byte)(nil)).Elem(), encoderMakerTTypex_Z)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, typex.Z) ([]byte, error))(nil)).Elem(), encoderMakerTTypex_ZE)
}

type encoderBool struct {
	fn func(bool) []byte
}

func encoderMakerBool(fn interface{}) reflectx.Func {
	f := fn.(func(bool) []byte)
	return &encoderBool{fn: f}
}

func (c *encoderBool) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderBool) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderBool) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(bool))
	return []interface{}{out}
}

func (c *encoderBool) Call1x1(v interface{}) interface{} {
	return c.fn(v.(bool))
}

type encoderBoolE struct {
	fn func(bool) ([]byte, error)
}

func encoderMakerBoolE(fn interface{}) reflectx.Func {
	f := fn.(func(bool) ([]byte, error))
	return &encoderBoolE{fn: f}
}

func (c *encoderBoolE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderBoolE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderBoolE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(bool))
	return []interface{}{v, err}
}

func (c *encoderBoolE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(bool))
}

type encoderTBool struct {
	fn func(reflect.Type, bool) []byte
}

func encoderMakerTBool(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, bool) []byte)
	return &encoderTBool{fn: f}
}

func (c *encoderTBool) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTBool) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTBool) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(bool))
	return []interface{}{out}
}

func (c *encoderTBool) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(bool))
}

type encoderTBoolE struct {
	fn func(reflect.Type, bool) ([]byte, error)
}

func encoderMakerTBoolE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, bool) ([]byte, error))
	return &encoderTBoolE{fn: f}
}

func (c *encoderTBoolE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTBoolE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTBoolE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(bool))
	return []interface{}{val, err}
}

func (c *encoderTBoolE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(bool))
}

type encoderString struct {
	fn func(string) []byte
}

func encoderMakerString(fn interface{}) reflectx.Func {
	f := fn.(func(string) []byte)
	return &encoderString{fn: f}
}

func (c *encoderString) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderString) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderString) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(string))
	return []interface{}{out}
}

func (c *encoderString) Call1x1(v interface{}) interface{} {
	return c.fn(v.(string))
}

type encoderStringE struct {
	fn func(string) ([]byte, error)
}

func encoderMakerStringE(fn interface{}) reflectx.Func {
	f := fn.(func(string) ([]byte, error))
	return &encoderStringE{fn: f}
}

func (c *encoderStringE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderStringE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderStringE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(string))
	return []interface{}{v, err}
}

func (c *encoderStringE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(string))
}

type encoderTString struct {
	fn func(reflect.Type, string) []byte
}

func encoderMakerTString(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, string) []byte)
	return &encoderTString{fn: f}
}

func (c *encoderTString) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTString) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTString) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(string))
	return []interface{}{out}
}

func (c *encoderTString) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(string))
}

type encoderTStringE struct {
	fn func(reflect.Type, string) ([]byte, error)
}

func encoderMakerTStringE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, string) ([]byte, error))
	return &encoderTStringE{fn: f}
}

func (c *encoderTStringE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTStringE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTStringE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(string))
	return []interface{}{val, err}
}

func (c *encoderTStringE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(string))
}

type encoderInt struct {
	fn func(int) []byte
}

func encoderMakerInt(fn interface{}) reflectx.Func {
	f := fn.(func(int) []byte)
	return &encoderInt{fn: f}
}

func (c *encoderInt) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(int))
	return []interface{}{out}
}

func (c *encoderInt) Call1x1(v interface{}) interface{} {
	return c.fn(v.(int))
}

type encoderIntE struct {
	fn func(int) ([]byte, error)
}

func encoderMakerIntE(fn interface{}) reflectx.Func {
	f := fn.(func(int) ([]byte, error))
	return &encoderIntE{fn: f}
}

func (c *encoderIntE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderIntE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderIntE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(int))
	return []interface{}{v, err}
}

func (c *encoderIntE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(int))
}

type encoderTInt struct {
	fn func(reflect.Type, int) []byte
}

func encoderMakerTInt(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int) []byte)
	return &encoderTInt{fn: f}
}

func (c *encoderTInt) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(int))
	return []interface{}{out}
}

func (c *encoderTInt) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(int))
}

type encoderTIntE struct {
	fn func(reflect.Type, int) ([]byte, error)
}

func encoderMakerTIntE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int) ([]byte, error))
	return &encoderTIntE{fn: f}
}

func (c *encoderTIntE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTIntE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTIntE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(int))
	return []interface{}{val, err}
}

func (c *encoderTIntE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(int))
}

type encoderInt8 struct {
	fn func(int8) []byte
}

func encoderMakerInt8(fn interface{}) reflectx.Func {
	f := fn.(func(int8) []byte)
	return &encoderInt8{fn: f}
}

func (c *encoderInt8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(int8))
	return []interface{}{out}
}

func (c *encoderInt8) Call1x1(v interface{}) interface{} {
	return c.fn(v.(int8))
}

type encoderInt8E struct {
	fn func(int8) ([]byte, error)
}

func encoderMakerInt8E(fn interface{}) reflectx.Func {
	f := fn.(func(int8) ([]byte, error))
	return &encoderInt8E{fn: f}
}

func (c *encoderInt8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt8E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(int8))
	return []interface{}{v, err}
}

func (c *encoderInt8E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(int8))
}

type encoderTInt8 struct {
	fn func(reflect.Type, int8) []byte
}

func encoderMakerTInt8(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int8) []byte)
	return &encoderTInt8{fn: f}
}

func (c *encoderTInt8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(int8))
	return []interface{}{out}
}

func (c *encoderTInt8) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(int8))
}

type encoderTInt8E struct {
	fn func(reflect.Type, int8) ([]byte, error)
}

func encoderMakerTInt8E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int8) ([]byte, error))
	return &encoderTInt8E{fn: f}
}

func (c *encoderTInt8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt8E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(int8))
	return []interface{}{val, err}
}

func (c *encoderTInt8E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(int8))
}

type encoderInt16 struct {
	fn func(int16) []byte
}

func encoderMakerInt16(fn interface{}) reflectx.Func {
	f := fn.(func(int16) []byte)
	return &encoderInt16{fn: f}
}

func (c *encoderInt16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(int16))
	return []interface{}{out}
}

func (c *encoderInt16) Call1x1(v interface{}) interface{} {
	return c.fn(v.(int16))
}

type encoderInt16E struct {
	fn func(int16) ([]byte, error)
}

func encoderMakerInt16E(fn interface{}) reflectx.Func {
	f := fn.(func(int16) ([]byte, error))
	return &encoderInt16E{fn: f}
}

func (c *encoderInt16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt16E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(int16))
	return []interface{}{v, err}
}

func (c *encoderInt16E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(int16))
}

type encoderTInt16 struct {
	fn func(reflect.Type, int16) []byte
}

func encoderMakerTInt16(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int16) []byte)
	return &encoderTInt16{fn: f}
}

func (c *encoderTInt16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(int16))
	return []interface{}{out}
}

func (c *encoderTInt16) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(int16))
}

type encoderTInt16E struct {
	fn func(reflect.Type, int16) ([]byte, error)
}

func encoderMakerTInt16E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int16) ([]byte, error))
	return &encoderTInt16E{fn: f}
}

func (c *encoderTInt16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt16E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(int16))
	return []interface{}{val, err}
}

func (c *encoderTInt16E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(int16))
}

type encoderInt32 struct {
	fn func(int32) []byte
}

func encoderMakerInt32(fn interface{}) reflectx.Func {
	f := fn.(func(int32) []byte)
	return &encoderInt32{fn: f}
}

func (c *encoderInt32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(int32))
	return []interface{}{out}
}

func (c *encoderInt32) Call1x1(v interface{}) interface{} {
	return c.fn(v.(int32))
}

type encoderInt32E struct {
	fn func(int32) ([]byte, error)
}

func encoderMakerInt32E(fn interface{}) reflectx.Func {
	f := fn.(func(int32) ([]byte, error))
	return &encoderInt32E{fn: f}
}

func (c *encoderInt32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt32E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(int32))
	return []interface{}{v, err}
}

func (c *encoderInt32E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(int32))
}

type encoderTInt32 struct {
	fn func(reflect.Type, int32) []byte
}

func encoderMakerTInt32(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int32) []byte)
	return &encoderTInt32{fn: f}
}

func (c *encoderTInt32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(int32))
	return []interface{}{out}
}

func (c *encoderTInt32) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(int32))
}

type encoderTInt32E struct {
	fn func(reflect.Type, int32) ([]byte, error)
}

func encoderMakerTInt32E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int32) ([]byte, error))
	return &encoderTInt32E{fn: f}
}

func (c *encoderTInt32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt32E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(int32))
	return []interface{}{val, err}
}

func (c *encoderTInt32E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(int32))
}

type encoderInt64 struct {
	fn func(int64) []byte
}

func encoderMakerInt64(fn interface{}) reflectx.Func {
	f := fn.(func(int64) []byte)
	return &encoderInt64{fn: f}
}

func (c *encoderInt64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(int64))
	return []interface{}{out}
}

func (c *encoderInt64) Call1x1(v interface{}) interface{} {
	return c.fn(v.(int64))
}

type encoderInt64E struct {
	fn func(int64) ([]byte, error)
}

func encoderMakerInt64E(fn interface{}) reflectx.Func {
	f := fn.(func(int64) ([]byte, error))
	return &encoderInt64E{fn: f}
}

func (c *encoderInt64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderInt64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderInt64E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(int64))
	return []interface{}{v, err}
}

func (c *encoderInt64E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(int64))
}

type encoderTInt64 struct {
	fn func(reflect.Type, int64) []byte
}

func encoderMakerTInt64(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int64) []byte)
	return &encoderTInt64{fn: f}
}

func (c *encoderTInt64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(int64))
	return []interface{}{out}
}

func (c *encoderTInt64) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(int64))
}

type encoderTInt64E struct {
	fn func(reflect.Type, int64) ([]byte, error)
}

func encoderMakerTInt64E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, int64) ([]byte, error))
	return &encoderTInt64E{fn: f}
}

func (c *encoderTInt64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTInt64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTInt64E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(int64))
	return []interface{}{val, err}
}

func (c *encoderTInt64E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(int64))
}

type encoderUint struct {
	fn func(uint) []byte
}

func encoderMakerUint(fn interface{}) reflectx.Func {
	f := fn.(func(uint) []byte)
	return &encoderUint{fn: f}
}

func (c *encoderUint) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(uint))
	return []interface{}{out}
}

func (c *encoderUint) Call1x1(v interface{}) interface{} {
	return c.fn(v.(uint))
}

type encoderUintE struct {
	fn func(uint) ([]byte, error)
}

func encoderMakerUintE(fn interface{}) reflectx.Func {
	f := fn.(func(uint) ([]byte, error))
	return &encoderUintE{fn: f}
}

func (c *encoderUintE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUintE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUintE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(uint))
	return []interface{}{v, err}
}

func (c *encoderUintE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(uint))
}

type encoderTUint struct {
	fn func(reflect.Type, uint) []byte
}

func encoderMakerTUint(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint) []byte)
	return &encoderTUint{fn: f}
}

func (c *encoderTUint) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(uint))
	return []interface{}{out}
}

func (c *encoderTUint) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(uint))
}

type encoderTUintE struct {
	fn func(reflect.Type, uint) ([]byte, error)
}

func encoderMakerTUintE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint) ([]byte, error))
	return &encoderTUintE{fn: f}
}

func (c *encoderTUintE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUintE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUintE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(uint))
	return []interface{}{val, err}
}

func (c *encoderTUintE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(uint))
}

type encoderUint8 struct {
	fn func(uint8) []byte
}

func encoderMakerUint8(fn interface{}) reflectx.Func {
	f := fn.(func(uint8) []byte)
	return &encoderUint8{fn: f}
}

func (c *encoderUint8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(uint8))
	return []interface{}{out}
}

func (c *encoderUint8) Call1x1(v interface{}) interface{} {
	return c.fn(v.(uint8))
}

type encoderUint8E struct {
	fn func(uint8) ([]byte, error)
}

func encoderMakerUint8E(fn interface{}) reflectx.Func {
	f := fn.(func(uint8) ([]byte, error))
	return &encoderUint8E{fn: f}
}

func (c *encoderUint8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint8E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(uint8))
	return []interface{}{v, err}
}

func (c *encoderUint8E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(uint8))
}

type encoderTUint8 struct {
	fn func(reflect.Type, uint8) []byte
}

func encoderMakerTUint8(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint8) []byte)
	return &encoderTUint8{fn: f}
}

func (c *encoderTUint8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(uint8))
	return []interface{}{out}
}

func (c *encoderTUint8) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(uint8))
}

type encoderTUint8E struct {
	fn func(reflect.Type, uint8) ([]byte, error)
}

func encoderMakerTUint8E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint8) ([]byte, error))
	return &encoderTUint8E{fn: f}
}

func (c *encoderTUint8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint8E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(uint8))
	return []interface{}{val, err}
}

func (c *encoderTUint8E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(uint8))
}

type encoderUint16 struct {
	fn func(uint16) []byte
}

func encoderMakerUint16(fn interface{}) reflectx.Func {
	f := fn.(func(uint16) []byte)
	return &encoderUint16{fn: f}
}

func (c *encoderUint16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(uint16))
	return []interface{}{out}
}

func (c *encoderUint16) Call1x1(v interface{}) interface{} {
	return c.fn(v.(uint16))
}

type encoderUint16E struct {
	fn func(uint16) ([]byte, error)
}

func encoderMakerUint16E(fn interface{}) reflectx.Func {
	f := fn.(func(uint16) ([]byte, error))
	return &encoderUint16E{fn: f}
}

func (c *encoderUint16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint16E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(uint16))
	return []interface{}{v, err}
}

func (c *encoderUint16E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(uint16))
}

type encoderTUint16 struct {
	fn func(reflect.Type, uint16) []byte
}

func encoderMakerTUint16(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint16) []byte)
	return &encoderTUint16{fn: f}
}

func (c *encoderTUint16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(uint16))
	return []interface{}{out}
}

func (c *encoderTUint16) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(uint16))
}

type encoderTUint16E struct {
	fn func(reflect.Type, uint16) ([]byte, error)
}

func encoderMakerTUint16E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint16) ([]byte, error))
	return &encoderTUint16E{fn: f}
}

func (c *encoderTUint16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint16E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(uint16))
	return []interface{}{val, err}
}

func (c *encoderTUint16E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(uint16))
}

type encoderUint32 struct {
	fn func(uint32) []byte
}

func encoderMakerUint32(fn interface{}) reflectx.Func {
	f := fn.(func(uint32) []byte)
	return &encoderUint32{fn: f}
}

func (c *encoderUint32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(uint32))
	return []interface{}{out}
}

func (c *encoderUint32) Call1x1(v interface{}) interface{} {
	return c.fn(v.(uint32))
}

type encoderUint32E struct {
	fn func(uint32) ([]byte, error)
}

func encoderMakerUint32E(fn interface{}) reflectx.Func {
	f := fn.(func(uint32) ([]byte, error))
	return &encoderUint32E{fn: f}
}

func (c *encoderUint32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint32E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(uint32))
	return []interface{}{v, err}
}

func (c *encoderUint32E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(uint32))
}

type encoderTUint32 struct {
	fn func(reflect.Type, uint32) []byte
}

func encoderMakerTUint32(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint32) []byte)
	return &encoderTUint32{fn: f}
}

func (c *encoderTUint32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(uint32))
	return []interface{}{out}
}

func (c *encoderTUint32) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(uint32))
}

type encoderTUint32E struct {
	fn func(reflect.Type, uint32) ([]byte, error)
}

func encoderMakerTUint32E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint32) ([]byte, error))
	return &encoderTUint32E{fn: f}
}

func (c *encoderTUint32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint32E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(uint32))
	return []interface{}{val, err}
}

func (c *encoderTUint32E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(uint32))
}

type encoderUint64 struct {
	fn func(uint64) []byte
}

func encoderMakerUint64(fn interface{}) reflectx.Func {
	f := fn.(func(uint64) []byte)
	return &encoderUint64{fn: f}
}

func (c *encoderUint64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(uint64))
	return []interface{}{out}
}

func (c *encoderUint64) Call1x1(v interface{}) interface{} {
	return c.fn(v.(uint64))
}

type encoderUint64E struct {
	fn func(uint64) ([]byte, error)
}

func encoderMakerUint64E(fn interface{}) reflectx.Func {
	f := fn.(func(uint64) ([]byte, error))
	return &encoderUint64E{fn: f}
}

func (c *encoderUint64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderUint64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderUint64E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(uint64))
	return []interface{}{v, err}
}

func (c *encoderUint64E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(uint64))
}

type encoderTUint64 struct {
	fn func(reflect.Type, uint64) []byte
}

func encoderMakerTUint64(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint64) []byte)
	return &encoderTUint64{fn: f}
}

func (c *encoderTUint64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(uint64))
	return []interface{}{out}
}

func (c *encoderTUint64) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(uint64))
}

type encoderTUint64E struct {
	fn func(reflect.Type, uint64) ([]byte, error)
}

func encoderMakerTUint64E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, uint64) ([]byte, error))
	return &encoderTUint64E{fn: f}
}

func (c *encoderTUint64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTUint64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTUint64E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(uint64))
	return []interface{}{val, err}
}

func (c *encoderTUint64E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(uint64))
}

type encoderFloat32 struct {
	fn func(float32) []byte
}

func encoderMakerFloat32(fn interface{}) reflectx.Func {
	f := fn.(func(float32) []byte)
	return &encoderFloat32{fn: f}
}

func (c *encoderFloat32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderFloat32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderFloat32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(float32))
	return []interface{}{out}
}

func (c *encoderFloat32) Call1x1(v interface{}) interface{} {
	return c.fn(v.(float32))
}

type encoderFloat32E struct {
	fn func(float32) ([]byte, error)
}

func encoderMakerFloat32E(fn interface{}) reflectx.Func {
	f := fn.(func(float32) ([]byte, error))
	return &encoderFloat32E{fn: f}
}

func (c *encoderFloat32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderFloat32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderFloat32E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(float32))
	return []interface{}{v, err}
}

func (c *encoderFloat32E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(float32))
}

type encoderTFloat32 struct {
	fn func(reflect.Type, float32) []byte
}

func encoderMakerTFloat32(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, float32) []byte)
	return &encoderTFloat32{fn: f}
}

func (c *encoderTFloat32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTFloat32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTFloat32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(float32))
	return []interface{}{out}
}

func (c *encoderTFloat32) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(float32))
}

type encoderTFloat32E struct {
	fn func(reflect.Type, float32) ([]byte, error)
}

func encoderMakerTFloat32E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, float32) ([]byte, error))
	return &encoderTFloat32E{fn: f}
}

func (c *encoderTFloat32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTFloat32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTFloat32E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(float32))
	return []interface{}{val, err}
}

func (c *encoderTFloat32E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(float32))
}

type encoderFloat64 struct {
	fn func(float64) []byte
}

func encoderMakerFloat64(fn interface{}) reflectx.Func {
	f := fn.(func(float64) []byte)
	return &encoderFloat64{fn: f}
}

func (c *encoderFloat64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderFloat64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderFloat64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(float64))
	return []interface{}{out}
}

func (c *encoderFloat64) Call1x1(v interface{}) interface{} {
	return c.fn(v.(float64))
}

type encoderFloat64E struct {
	fn func(float64) ([]byte, error)
}

func encoderMakerFloat64E(fn interface{}) reflectx.Func {
	f := fn.(func(float64) ([]byte, error))
	return &encoderFloat64E{fn: f}
}

func (c *encoderFloat64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderFloat64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderFloat64E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(float64))
	return []interface{}{v, err}
}

func (c *encoderFloat64E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(float64))
}

type encoderTFloat64 struct {
	fn func(reflect.Type, float64) []byte
}

func encoderMakerTFloat64(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, float64) []byte)
	return &encoderTFloat64{fn: f}
}

func (c *encoderTFloat64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTFloat64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTFloat64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(float64))
	return []interface{}{out}
}

func (c *encoderTFloat64) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(float64))
}

type encoderTFloat64E struct {
	fn func(reflect.Type, float64) ([]byte, error)
}

func encoderMakerTFloat64E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, float64) ([]byte, error))
	return &encoderTFloat64E{fn: f}
}

func (c *encoderTFloat64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTFloat64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTFloat64E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(float64))
	return []interface{}{val, err}
}

func (c *encoderTFloat64E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(float64))
}

type encoderTypex_T struct {
	fn func(typex.T) []byte
}

func encoderMakerTypex_T(fn interface{}) reflectx.Func {
	f := fn.(func(typex.T) []byte)
	return &encoderTypex_T{fn: f}
}

func (c *encoderTypex_T) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_T) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_T) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.T))
	return []interface{}{out}
}

func (c *encoderTypex_T) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.T))
}

type encoderTypex_TE struct {
	fn func(typex.T) ([]byte, error)
}

func encoderMakerTypex_TE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.T) ([]byte, error))
	return &encoderTypex_TE{fn: f}
}

func (c *encoderTypex_TE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_TE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_TE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.T))
	return []interface{}{v, err}
}

func (c *encoderTypex_TE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.T))
}

type encoderTTypex_T struct {
	fn func(reflect.Type, typex.T) []byte
}

func encoderMakerTTypex_T(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.T) []byte)
	return &encoderTTypex_T{fn: f}
}

func (c *encoderTTypex_T) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_T) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_T) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.T))
	return []interface{}{out}
}

func (c *encoderTTypex_T) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.T))
}

type encoderTTypex_TE struct {
	fn func(reflect.Type, typex.T) ([]byte, error)
}

func encoderMakerTTypex_TE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.T) ([]byte, error))
	return &encoderTTypex_TE{fn: f}
}

func (c *encoderTTypex_TE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_TE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_TE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.T))
	return []interface{}{val, err}
}

func (c *encoderTTypex_TE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.T))
}

type encoderTypex_U struct {
	fn func(typex.U) []byte
}

func encoderMakerTypex_U(fn interface{}) reflectx.Func {
	f := fn.(func(typex.U) []byte)
	return &encoderTypex_U{fn: f}
}

func (c *encoderTypex_U) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_U) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_U) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.U))
	return []interface{}{out}
}

func (c *encoderTypex_U) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.U))
}

type encoderTypex_UE struct {
	fn func(typex.U) ([]byte, error)
}

func encoderMakerTypex_UE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.U) ([]byte, error))
	return &encoderTypex_UE{fn: f}
}

func (c *encoderTypex_UE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_UE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_UE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.U))
	return []interface{}{v, err}
}

func (c *encoderTypex_UE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.U))
}

type encoderTTypex_U struct {
	fn func(reflect.Type, typex.U) []byte
}

func encoderMakerTTypex_U(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.U) []byte)
	return &encoderTTypex_U{fn: f}
}

func (c *encoderTTypex_U) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_U) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_U) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.U))
	return []interface{}{out}
}

func (c *encoderTTypex_U) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.U))
}

type encoderTTypex_UE struct {
	fn func(reflect.Type, typex.U) ([]byte, error)
}

func encoderMakerTTypex_UE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.U) ([]byte, error))
	return &encoderTTypex_UE{fn: f}
}

func (c *encoderTTypex_UE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_UE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_UE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.U))
	return []interface{}{val, err}
}

func (c *encoderTTypex_UE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.U))
}

type encoderTypex_V struct {
	fn func(typex.V) []byte
}

func encoderMakerTypex_V(fn interface{}) reflectx.Func {
	f := fn.(func(typex.V) []byte)
	return &encoderTypex_V{fn: f}
}

func (c *encoderTypex_V) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_V) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_V) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.V))
	return []interface{}{out}
}

func (c *encoderTypex_V) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.V))
}

type encoderTypex_VE struct {
	fn func(typex.V) ([]byte, error)
}

func encoderMakerTypex_VE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.V) ([]byte, error))
	return &encoderTypex_VE{fn: f}
}

func (c *encoderTypex_VE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_VE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_VE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.V))
	return []interface{}{v, err}
}

func (c *encoderTypex_VE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.V))
}

type encoderTTypex_V struct {
	fn func(reflect.Type, typex.V) []byte
}

func encoderMakerTTypex_V(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.V) []byte)
	return &encoderTTypex_V{fn: f}
}

func (c *encoderTTypex_V) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_V) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_V) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.V))
	return []interface{}{out}
}

func (c *encoderTTypex_V) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.V))
}

type encoderTTypex_VE struct {
	fn func(reflect.Type, typex.V) ([]byte, error)
}

func encoderMakerTTypex_VE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.V) ([]byte, error))
	return &encoderTTypex_VE{fn: f}
}

func (c *encoderTTypex_VE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_VE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_VE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.V))
	return []interface{}{val, err}
}

func (c *encoderTTypex_VE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.V))
}

type encoderTypex_W struct {
	fn func(typex.W) []byte
}

func encoderMakerTypex_W(fn interface{}) reflectx.Func {
	f := fn.(func(typex.W) []byte)
	return &encoderTypex_W{fn: f}
}

func (c *encoderTypex_W) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_W) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_W) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.W))
	return []interface{}{out}
}

func (c *encoderTypex_W) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.W))
}

type encoderTypex_WE struct {
	fn func(typex.W) ([]byte, error)
}

func encoderMakerTypex_WE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.W) ([]byte, error))
	return &encoderTypex_WE{fn: f}
}

func (c *encoderTypex_WE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_WE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_WE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.W))
	return []interface{}{v, err}
}

func (c *encoderTypex_WE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.W))
}

type encoderTTypex_W struct {
	fn func(reflect.Type, typex.W) []byte
}

func encoderMakerTTypex_W(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.W) []byte)
	return &encoderTTypex_W{fn: f}
}

func (c *encoderTTypex_W) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_W) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_W) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.W))
	return []interface{}{out}
}

func (c *encoderTTypex_W) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.W))
}

type encoderTTypex_WE struct {
	fn func(reflect.Type, typex.W) ([]byte, error)
}

func encoderMakerTTypex_WE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.W) ([]byte, error))
	return &encoderTTypex_WE{fn: f}
}

func (c *encoderTTypex_WE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_WE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_WE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.W))
	return []interface{}{val, err}
}

func (c *encoderTTypex_WE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.W))
}

type encoderTypex_X struct {
	fn func(typex.X) []byte
}

func encoderMakerTypex_X(fn interface{}) reflectx.Func {
	f := fn.(func(typex.X) []byte)
	return &encoderTypex_X{fn: f}
}

func (c *encoderTypex_X) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_X) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_X) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.X))
	return []interface{}{out}
}

func (c *encoderTypex_X) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.X))
}

type encoderTypex_XE struct {
	fn func(typex.X) ([]byte, error)
}

func encoderMakerTypex_XE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.X) ([]byte, error))
	return &encoderTypex_XE{fn: f}
}

func (c *encoderTypex_XE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_XE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_XE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.X))
	return []interface{}{v, err}
}

func (c *encoderTypex_XE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.X))
}

type encoderTTypex_X struct {
	fn func(reflect.Type, typex.X) []byte
}

func encoderMakerTTypex_X(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.X) []byte)
	return &encoderTTypex_X{fn: f}
}

func (c *encoderTTypex_X) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_X) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_X) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.X))
	return []interface{}{out}
}

func (c *encoderTTypex_X) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.X))
}

type encoderTTypex_XE struct {
	fn func(reflect.Type, typex.X) ([]byte, error)
}

func encoderMakerTTypex_XE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.X) ([]byte, error))
	return &encoderTTypex_XE{fn: f}
}

func (c *encoderTTypex_XE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_XE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_XE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.X))
	return []interface{}{val, err}
}

func (c *encoderTTypex_XE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.X))
}

type encoderTypex_Y struct {
	fn func(typex.Y) []byte
}

func encoderMakerTypex_Y(fn interface{}) reflectx.Func {
	f := fn.(func(typex.Y) []byte)
	return &encoderTypex_Y{fn: f}
}

func (c *encoderTypex_Y) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_Y) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_Y) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.Y))
	return []interface{}{out}
}

func (c *encoderTypex_Y) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.Y))
}

type encoderTypex_YE struct {
	fn func(typex.Y) ([]byte, error)
}

func encoderMakerTypex_YE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.Y) ([]byte, error))
	return &encoderTypex_YE{fn: f}
}

func (c *encoderTypex_YE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_YE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_YE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.Y))
	return []interface{}{v, err}
}

func (c *encoderTypex_YE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.Y))
}

type encoderTTypex_Y struct {
	fn func(reflect.Type, typex.Y) []byte
}

func encoderMakerTTypex_Y(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.Y) []byte)
	return &encoderTTypex_Y{fn: f}
}

func (c *encoderTTypex_Y) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_Y) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_Y) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.Y))
	return []interface{}{out}
}

func (c *encoderTTypex_Y) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.Y))
}

type encoderTTypex_YE struct {
	fn func(reflect.Type, typex.Y) ([]byte, error)
}

func encoderMakerTTypex_YE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.Y) ([]byte, error))
	return &encoderTTypex_YE{fn: f}
}

func (c *encoderTTypex_YE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_YE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_YE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.Y))
	return []interface{}{val, err}
}

func (c *encoderTTypex_YE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.Y))
}

type encoderTypex_Z struct {
	fn func(typex.Z) []byte
}

func encoderMakerTypex_Z(fn interface{}) reflectx.Func {
	f := fn.(func(typex.Z) []byte)
	return &encoderTypex_Z{fn: f}
}

func (c *encoderTypex_Z) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_Z) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_Z) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(typex.Z))
	return []interface{}{out}
}

func (c *encoderTypex_Z) Call1x1(v interface{}) interface{} {
	return c.fn(v.(typex.Z))
}

type encoderTypex_ZE struct {
	fn func(typex.Z) ([]byte, error)
}

func encoderMakerTypex_ZE(fn interface{}) reflectx.Func {
	f := fn.(func(typex.Z) ([]byte, error))
	return &encoderTypex_ZE{fn: f}
}

func (c *encoderTypex_ZE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTypex_ZE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTypex_ZE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].(typex.Z))
	return []interface{}{v, err}
}

func (c *encoderTypex_ZE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.(typex.Z))
}

type encoderTTypex_Z struct {
	fn func(reflect.Type, typex.Z) []byte
}

func encoderMakerTTypex_Z(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.Z) []byte)
	return &encoderTTypex_Z{fn: f}
}

func (c *encoderTTypex_Z) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_Z) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_Z) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].(typex.Z))
	return []interface{}{out}
}

func (c *encoderTTypex_Z) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.(typex.Z))
}

type encoderTTypex_ZE struct {
	fn func(reflect.Type, typex.Z) ([]byte, error)
}

func encoderMakerTTypex_ZE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, typex.Z) ([]byte, error))
	return &encoderTTypex_ZE{fn: f}
}

func (c *encoderTTypex_ZE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *encoderTTypex_ZE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *encoderTTypex_ZE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].(typex.Z))
	return []interface{}{val, err}
}

func (c *encoderTTypex_ZE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.(typex.Z))
}
