/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.swing.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.axis2.tool.service.bean.Page3Bean;
import org.apache.axis2.tool.service.bean.WizardBean;
import org.apache.axis2.tool.service.swing.ui.WizardPane;

public class WizardPane3
extends WizardPane {
    private Page3Bean myBean;
    private JLabel outputFileLocationLabel;
    private JTextField outputFileLocationTextBox;
    private JButton browseButton;
    private JLabel outputFileNameLabel;
    private JTextField outputFileNameTextBox;

    public WizardPane3(WizardBean bean, JFrame ownerFrame) {
        super(ownerFrame);
        this.init();
        if (bean.getPage3bean() != null) {
            this.myBean = bean.getPage3bean();
            this.setBeanValues();
        } else {
            this.myBean = new Page3Bean();
            bean.setPage3bean(this.myBean);
        }
    }

    @Override
    public boolean validateValues() {
        String text1 = this.myBean.getOutputFileName();
        String text2 = this.myBean.getOutputFolderName();
        boolean text1Validity = text1 != null && text1.trim().length() > 0;
        boolean text2Validity = text2 != null && text2.trim().length() > 0;
        return text1Validity && text2Validity;
    }

    private void setBeanValues() {
        this.outputFileLocationTextBox.setText(this.myBean.getOutputFolderName());
        this.outputFileNameTextBox.setText(this.myBean.getOutputFileName());
    }

    private void init() {
        this.setLayout(null);
        this.setSize(this.width, this.height);
        this.initDescription("\nInput the location for the output file and the name for \nthe compiled jar file ");
        this.outputFileLocationLabel = new JLabel("Output Folder");
        this.add(this.outputFileLocationLabel);
        this.outputFileLocationLabel.setBounds(this.hgap, this.descHeight, 100, 20);
        this.outputFileLocationTextBox = new JTextField();
        this.add(this.outputFileLocationTextBox);
        this.outputFileLocationTextBox.setBounds(100 + 2 * this.hgap, this.descHeight, 250, 20);
        this.outputFileLocationTextBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane3.this.handleLocationChange();
            }
        });
        this.outputFileLocationTextBox.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                WizardPane3.this.handleLocationChange();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.browseButton = new JButton(".");
        this.add(this.browseButton);
        this.browseButton.setBounds(100 + 2 * this.hgap + 250, this.descHeight, 20, 20);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane3.this.outputFileLocationTextBox.setText(WizardPane3.this.browseForAFolder());
                WizardPane3.this.handleLocationChange();
            }
        });
        this.outputFileNameLabel = new JLabel("Out File Name");
        this.add(this.outputFileNameLabel);
        this.outputFileNameLabel.setBounds(this.hgap, this.descHeight + 20 + this.vgap, 100, 20);
        this.outputFileNameTextBox = new JTextField();
        this.add(this.outputFileNameTextBox);
        this.outputFileNameTextBox.setBounds(100 + 2 * this.hgap, this.descHeight + 20 + this.vgap, 250, 20);
        this.outputFileNameTextBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane3.this.handleFileNameChange();
            }
        });
        this.outputFileNameTextBox.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                WizardPane3.this.handleFileNameChange();
            }
        });
    }

    private void handleLocationChange() {
        this.myBean.setOutputFolderName(this.outputFileLocationTextBox.getText());
    }

    private void handleFileNameChange() {
        this.myBean.setOutputFileName(this.outputFileNameTextBox.getText());
    }
}

