/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAP12Constants;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.kernel.RequestResponseTransport;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.axis2.transport.http.server.AxisHttpRequestImpl;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.axis2.transport.http.server.AxisHttpResponseImpl;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.ServerSupport;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;

public class AxisHttpService {
    private static final Log LOG = LogFactory.getLog(AxisHttpService.class);
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connStrategy;
    private final DefaultClassicHttpResponseFactory responseFactory;
    private final ConfigurationContext configurationContext;
    private final Http1StreamListener streamListener;
    private final Worker worker;

    public AxisHttpService(HttpProcessor httpProcessor, Http1Config http1Config, ConnectionReuseStrategy connStrategy, Http1StreamListener streamListener, DefaultClassicHttpResponseFactory responseFactory, ConfigurationContext configurationContext, Worker worker) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (worker == null) {
            throw new IllegalArgumentException("Worker may not be null");
        }
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connStrategy = connStrategy != null ? connStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = streamListener;
        this.responseFactory = responseFactory;
        this.configurationContext = configurationContext;
        this.worker = worker;
    }

    public void handleRequest(AxisHttpConnection conn, HttpContext localContext) throws IOException, HttpException {
        AtomicBoolean responseSubmitted = new AtomicBoolean(false);
        HttpCoreContext context = HttpCoreContext.cast((HttpContext)localContext);
        MessageContext msgContext = this.configurationContext.createMessageContext();
        msgContext.setIncomingTransportName("http");
        if (conn != null) {
            InetSocketAddress remoteAddress = (InetSocketAddress)conn.getRemoteAddress();
            String remoteIPAddress = remoteAddress.getAddress().getHostAddress();
            InetSocketAddress localAddress = (InetSocketAddress)conn.getLocalAddress();
            String localIPAddress = localAddress.getAddress().getHostAddress();
            msgContext.setProperty("REMOTE_ADDR", (Object)remoteIPAddress);
            msgContext.setProperty("TRANSPORT_ADDR", (Object)localIPAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remote address of the connection : " + remoteIPAddress));
            }
        }
        ClassicHttpResponse response = null;
        ClassicHttpRequest request = null;
        try {
            OutputStream outstream;
            ProtocolVersion transportVersion;
            RequestLine requestLine;
            request = conn.receiveRequest();
            if (request == null) {
                LOG.error((Object)"AxisHttpService.handleRequest() returning on null request, will close the connection");
                conn.close();
                return;
            }
            if (this.streamListener != null) {
                this.streamListener.onRequestHead((HttpConnection)conn, (HttpRequest)request);
            }
            if ((requestLine = new RequestLine((HttpRequest)request)) != null) {
                msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)requestLine.getMethod());
            }
            if ((transportVersion = request.getVersion()) != null && transportVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_2)) {
                transportVersion = HttpVersion.HTTP_1_1;
                LOG.warn((Object)"http2 or greater detected, the request has been downgraded to HTTP/1.1");
            }
            context.setProtocolVersion((ProtocolVersion)(transportVersion != null ? transportVersion : this.http1Config.getVersion()));
            context.setRequest((HttpRequest)request);
            response = this.responseFactory.newHttpResponse(200);
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            if (clientContext.getRequestConfigOrDefault().isExpectContinueEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"isExpectContinueEnabled is true");
                }
                ClassicHttpResponse ack = this.responseFactory.newHttpResponse(100);
                conn.sendResponse(ack);
                conn.flush();
            }
            AxisHttpRequestImpl axisreq = new AxisHttpRequestImpl(conn, request, this.httpProcessor, (HttpContext)context);
            AxisHttpResponseImpl axisres = new AxisHttpResponseImpl(conn, response, this.httpProcessor, (HttpContext)context);
            axisreq.prepare();
            this.doService(axisreq, axisres, (HttpContext)context, msgContext);
            InputStream instream = conn.getInputStream();
            if (instream != null) {
                instream.close();
            }
            if (!axisres.isCommitted()) {
                axisres.commit();
            }
            if ((outstream = conn.getOutputStream()) != null) {
                outstream.close();
            }
        }
        catch (HttpException ex) {
            if (responseSubmitted.get()) {
                throw ex;
            }
            try (BasicClassicHttpResponse errorResponse = new BasicClassicHttpResponse(500);){
                this.handleException(ex, (ClassicHttpResponse)errorResponse);
                errorResponse.setHeader("Connection", (Object)"close");
                context.setResponse((HttpResponse)errorResponse);
                this.httpProcessor.process((HttpResponse)errorResponse, (EntityDetails)errorResponse.getEntity(), (HttpContext)context);
                conn.sendResponse((ClassicHttpResponse)errorResponse);
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead((HttpConnection)conn, (HttpResponse)errorResponse);
                }
                conn.close();
            }
        }
        conn.flush();
        if (request != null && response != null) {
            boolean keepAlive = this.connStrategy.keepAlive((HttpRequest)request, (HttpResponse)response, localContext);
            if (!keepAlive) {
                conn.close();
            } else {
                conn.reset();
            }
            response.close();
        }
    }

    protected void handleException(HttpException ex, ClassicHttpResponse response) {
        response.setCode(this.toStatusCode((Exception)((Object)ex)));
        response.setEntity((HttpEntity)new StringEntity(ServerSupport.toErrorMessage((Exception)((Object)ex)), ContentType.TEXT_PLAIN));
    }

    protected int toStatusCode(Exception ex) {
        return ServerSupport.toStatusCode((Exception)ex);
    }

    protected void doService(AxisHttpRequest request, AxisHttpResponse response, HttpContext context, MessageContext msgContext) throws HttpException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Request method: " + request.getMethod()));
            LOG.debug((Object)("Target URI: " + request.getRequestURI()));
        }
        try {
            TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
            TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
            String sessionKey = (String)context.getAttribute("Cookie");
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            msgContext.setServerSide(true);
            msgContext.setProperty("Cookie", (Object)sessionKey);
            msgContext.setProperty("TransportInURL", (Object)request.getRequestURI());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            Iterator it = request.headerIterator();
            while (it.hasNext()) {
                Header header = (Header)it.next();
                headerMap.put(header.getName(), header.getValue());
            }
            msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
            msgContext.setProperty("ContentType", (Object)request.getContentType());
            msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
            msgContext.setProperty("OutTransportInfo", (Object)response);
            msgContext.setTo(new EndpointReference(request.getRequestURI()));
            msgContext.setProperty("RequestResponseTransportControl", (Object)new SimpleHTTPRequestResponseTransport());
            this.worker.service(request, response, msgContext);
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (HttpException ex) {
            throw ex;
        }
        catch (Throwable e) {
            LOG.debug((Object)"Processing exception", e);
            msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
            msgContext.setProperty("OutTransportInfo", (Object)response);
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
            if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                response.setStatus(202);
            } else {
                String state = (String)msgContext.getProperty("axis2.http.response.state");
                if (state != null) {
                    int stateInt = Integer.parseInt(state);
                    response.setStatus(stateInt);
                    if (stateInt == 401) {
                        String realm = (String)msgContext.getProperty("axis2.authentication.realm");
                        response.addHeader("WWW-Authenticate", "basic realm=\"" + realm + "\"");
                    }
                } else if (e instanceof AxisFault) {
                    response.sendError(this.getStatusFromAxisFault((AxisFault)e), e.getMessage());
                } else {
                    response.sendError(500, "Internal server error");
                }
            }
            AxisEngine.sendFault((MessageContext)faultContext);
        }
    }

    public int getStatusFromAxisFault(AxisFault fault) {
        QName faultCode = fault.getFaultCode();
        if (SOAP12Constants.QNAME_SENDER_FAULTCODE.equals(faultCode) || SOAP11Constants.QNAME_SENDER_FAULTCODE.equals(faultCode)) {
            return 400;
        }
        return 500;
    }

    class SimpleHTTPRequestResponseTransport
    implements RequestResponseTransport {
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        AxisFault faultToBeThrownOut = null;
        private boolean responseWritten = false;

        SimpleHTTPRequestResponseTransport() {
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }

        public boolean isResponseWritten() {
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            this.responseWritten = responseWritten;
        }
    }
}

