/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import org.apache.axis2.tool.service.bean.ClassFileSelectionBean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceArchiveWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ClassFileLocationPage
extends AbstractServiceWizardPage {
    private Text classFileLocationText;
    private Button filterByClassFilesCheckBox;

    public ClassFileLocationPage() {
        super("page1");
    }

    @Override
    protected void initializeDefaultSettings() {
        this.settings.put("CLASS_FILE_LOCATION", System.getProperty("user.dir"));
        this.settings.put("FILTER_BY_CLASSES", true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        Label lable = new Label(container, 0);
        lable.setText(ServiceArchiver.getResourceString("page1.fileLocationLabel"));
        this.classFileLocationText = new Text(container, 2048);
        this.classFileLocationText.setLayoutData((Object)gd);
        this.classFileLocationText.setText(this.settings.get("CLASS_FILE_LOCATION"));
        this.classFileLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClassFileLocationPage.this.handleModify();
            }
        });
        Button browseButton = new Button(container, 8);
        browseButton.setText(ServiceArchiver.getResourceString("general.browse"));
        browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ClassFileLocationPage.this.handleBrowse();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.filterByClassFilesCheckBox = new Button(container, 32);
        this.filterByClassFilesCheckBox.setLayoutData((Object)gd);
        this.filterByClassFilesCheckBox.setText(ServiceArchiver.getResourceString("page1.filter.caption"));
        this.filterByClassFilesCheckBox.setSelection(this.settings.getBoolean("FILTER_BY_CLASSES"));
        this.filterByClassFilesCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClassFileLocationPage.this.settings.put("FILTER_BY_CLASSES", ClassFileLocationPage.this.filterByClassFilesCheckBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)container);
        if (this.restoredFromPreviousSettings) {
            this.handleModify();
        }
    }

    private void handleBrowse() {
        DirectoryDialog dirDialog = new DirectoryDialog(this.getShell());
        dirDialog.setMessage(ServiceArchiver.getResourceString("page1.filedialogTitle"));
        String returnText = dirDialog.open();
        if (returnText != null) {
            this.classFileLocationText.setText(returnText);
        }
    }

    private void handleModify() {
        String classLocationText = this.classFileLocationText.getText().trim();
        this.settings.put("CLASS_FILE_LOCATION", classLocationText);
        ((ServiceArchiveWizard)this.getWizard()).setClassFileLocation(classLocationText);
        if ("".equals(classLocationText)) {
            this.updateStatus(ServiceArchiver.getResourceString("page1.error.filemissing"));
        } else {
            this.updateStatus(null);
        }
    }

    public String getClassFileLocation() {
        return this.classFileLocationText.getText();
    }

    public ClassFileSelectionBean getBean() {
        ClassFileSelectionBean pageBean = new ClassFileSelectionBean();
        pageBean.setFileLocation(this.classFileLocationText.getText());
        if (this.filterByClassFilesCheckBox.getSelection()) {
            pageBean.setFilter(".class");
        }
        return pageBean;
    }

    @Override
    protected boolean getWizardComplete() {
        return false;
    }
}

