/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.stax.pull;

import java.io.Closeable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StAXPullReader
implements XmlReader {
    private static final Log log = LogFactory.getLog(StAXPullReader.class);
    private XMLStreamReader parser;
    private final XmlHandler handler;
    private final Closeable closeable;
    public final boolean autoClose;
    private boolean _isClosed = false;
    private DataHandlerReader dataHandlerReader;
    private Exception parserException;
    private boolean start = true;

    public StAXPullReader(XMLStreamReader parser, XmlHandler handler, Closeable closeable, boolean autoClose) {
        if (parser.getEventType() != 7) {
            throw new IllegalStateException("The XMLStreamReader must be positioned on a START_DOCUMENT event");
        }
        this.parser = parser;
        this.handler = handler;
        this.closeable = closeable;
        this.autoClose = autoClose;
        this.dataHandlerReader = XMLStreamReaderUtils.getDataHandlerReader((XMLStreamReader)parser);
    }

    private static String normalize(String s) {
        return s == null ? "" : s;
    }

    private void processText(int textType) throws StreamException {
        if (textType == 4 && this.dataHandlerReader != null && this.dataHandlerReader.isBinary()) {
            TextContent data;
            if (this.dataHandlerReader.isDeferred()) {
                data = new TextContent(this.dataHandlerReader.getContentID(), this.dataHandlerReader.getDataHandlerProvider(), this.dataHandlerReader.isOptimized());
            } else {
                try {
                    data = new TextContent(this.dataHandlerReader.getContentID(), this.dataHandlerReader.getDataHandler(), this.dataHandlerReader.isOptimized());
                }
                catch (XMLStreamException ex) {
                    throw new OMException((Throwable)ex);
                }
            }
            this.handler.processCharacterData(data, false);
        } else {
            String text;
            try {
                text = this.parser.getText();
            }
            catch (RuntimeException ex) {
                this.parserException = ex;
                throw ex;
            }
            switch (textType) {
                case 4: {
                    this.handler.processCharacterData(text, false);
                    break;
                }
                case 6: {
                    this.handler.processCharacterData(text, true);
                    break;
                }
                case 12: {
                    this.handler.startCDATASection();
                    this.handler.processCharacterData(text, false);
                    this.handler.endCDATASection();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void dispose() {
        try {
            try {
                if (!this._isClosed) {
                    this.parser.close();
                    if (this.closeable != null) {
                        this.closeable.close();
                    }
                }
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception occurred during parser close.  Processing continues. " + e));
                }
                this._isClosed = true;
                this.parser = null;
            }
        }
        finally {
            this._isClosed = true;
            this.parser = null;
        }
    }

    @Override
    public boolean proceed() throws StreamException {
        int token = this.parserNext();
        switch (token) {
            case 7: {
                this.handler.startDocument(this.parser.getEncoding(), this.parser.getVersion(), this.parser.getCharacterEncodingScheme(), this.parser.standaloneSet() ? Boolean.valueOf(this.parser.isStandalone()) : null);
                break;
            }
            case 1: {
                this.processElement();
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                this.processText(token);
                break;
            }
            case 2: {
                this.handler.endElement();
                break;
            }
            case 8: {
                this.handler.completed();
                break;
            }
            case 5: {
                this.handler.startComment();
                this.handler.processCharacterData(this.parser.getText(), false);
                this.handler.endComment();
                break;
            }
            case 11: {
                this.processDTD();
                break;
            }
            case 3: {
                this.handler.startProcessingInstruction(this.parser.getPITarget());
                this.handler.processCharacterData(this.parser.getPIData(), false);
                this.handler.endProcessingInstruction();
                break;
            }
            case 9: {
                this.handler.processEntityReference(this.parser.getLocalName(), this.parser.getText());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return token == 8;
    }

    private void processElement() throws StreamException {
        String namespaceURI = StAXPullReader.normalize(this.parser.getNamespaceURI());
        String localName = this.parser.getLocalName();
        String prefix = StAXPullReader.normalize(this.parser.getPrefix());
        this.handler.startElement(namespaceURI, localName, prefix);
        int i = 0;
        int count = this.parser.getNamespaceCount();
        while (i < count) {
            this.handler.processNamespaceDeclaration(StAXPullReader.normalize(this.parser.getNamespacePrefix(i)), StAXPullReader.normalize(this.parser.getNamespaceURI(i)));
            ++i;
        }
        i = 0;
        count = this.parser.getAttributeCount();
        while (i < count) {
            this.handler.processAttribute(StAXPullReader.normalize(this.parser.getAttributeNamespace(i)), this.parser.getAttributeLocalName(i), StAXPullReader.normalize(this.parser.getAttributePrefix(i)), this.parser.getAttributeValue(i), this.parser.getAttributeType(i), this.parser.isAttributeSpecified(i));
            ++i;
        }
        this.handler.attributesCompleted();
    }

    private void processDTD() throws StreamException {
        DTDReader dtdReader;
        try {
            dtdReader = (DTDReader)this.parser.getProperty(DTDReader.PROPERTY);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dtdReader = null;
        }
        if (dtdReader == null) {
            throw new StreamException("Cannot process DTD events because the XMLStreamReader doesn't support the DTDReader extension");
        }
        String internalSubset = this.getDTDText();
        if (internalSubset != null && internalSubset.length() == 0) {
            internalSubset = null;
        }
        this.handler.processDocumentTypeDeclaration(dtdReader.getRootName(), dtdReader.getPublicId(), dtdReader.getSystemId(), internalSubset);
    }

    private String getDTDText() throws OMException {
        String text;
        block3: {
            text = null;
            try {
                text = this.parser.getText();
            }
            catch (RuntimeException e) {
                Boolean b = (Boolean)this.parser.getProperty("javax.xml.stream.isSupportingExternalEntities");
                if (b == null || b == Boolean.TRUE) {
                    throw e;
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("An exception occurred while calling getText() for a DOCTYPE.  The exception is ignored because external entites support is disabled.  The ignored exception is " + e));
            }
        }
        return text;
    }

    private int parserNext() {
        if (this.start) {
            this.start = false;
            return this.parser.getEventType();
        }
        try {
            int event;
            if (this.parserException != null) {
                log.warn((Object)"Attempt to access a parser that has thrown a parse exception before; rethrowing the original exception.");
                if (this.parserException instanceof XMLStreamException) {
                    throw (XMLStreamException)this.parserException;
                }
                throw (RuntimeException)this.parserException;
            }
            try {
                event = this.parser.next();
            }
            catch (XMLStreamException ex) {
                this.parserException = ex;
                throw ex;
            }
            if (this.autoClose && event == 8) {
                this.dispose();
            }
            return event;
        }
        catch (XMLStreamException ex) {
            throw new DeferredParsingException((Throwable)ex);
        }
    }
}

