/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleMainClass
extends Attribute {
    private int main_class_index;

    public ModuleMainClass(ModuleMainClass c) {
        this(c.getNameIndex(), c.getLength(), c.getHostClassIndex(), c.getConstantPool());
    }

    public ModuleMainClass(int name_index, int length, int main_class_index, ConstantPool constant_pool) {
        super((byte)26, name_index, length, constant_pool);
        this.main_class_index = main_class_index;
    }

    ModuleMainClass(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, 0, constant_pool);
        this.main_class_index = input.readUnsignedShort();
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleMainClass(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.main_class_index);
    }

    public int getHostClassIndex() {
        return this.main_class_index;
    }

    public void setHostClassIndex(int main_class_index) {
        this.main_class_index = main_class_index;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModuleMainClass: ");
        String class_name = super.getConstantPool().getConstantString(this.main_class_index, (byte)7);
        buf.append(Utility.compactClassName(class_name, false));
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ModuleMainClass c = (ModuleMainClass)this.clone();
        c.setConstantPool(_constant_pool);
        return c;
    }
}

