/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IWindowAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.operators.aggrun.AbstractRunningAggregatePushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;

public abstract class AbstractWindowPushRuntime
extends AbstractRunningAggregatePushRuntime<IWindowAggregateEvaluator> {
    protected final SourceLocation sourceLoc;
    private final int[] partitionColumns;
    private final IBinaryComparatorFactory[] partitionComparatorFactories;
    private IBinaryComparator[] partitionComparators;
    private final IBinaryComparatorFactory[] orderComparatorFactories;
    private FrameTupleAccessor frameAccessor;
    private FrameTupleReference partitionColumnsRef;
    private PointableTupleReference partitionColumnsPrevCopy;
    private long frameId;
    private boolean inPartition;

    AbstractWindowPushRuntime(int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, IHyracksTaskContext ctx, SourceLocation sourceLoc) {
        super(projectionColumns, runningAggOutColumns, runningAggFactories, IWindowAggregateEvaluator.class, ctx);
        this.partitionColumns = partitionColumns;
        this.partitionComparatorFactories = partitionComparatorFactories;
        this.orderComparatorFactories = orderComparatorFactories;
        this.sourceLoc = sourceLoc;
    }

    int getReservedFrameCount() {
        return 2;
    }

    @Override
    public void open() throws HyracksDataException {
        super.open();
        this.frameId = 0L;
        this.inPartition = false;
    }

    @Override
    protected void init() throws HyracksDataException {
        super.init();
        this.partitionComparators = AbstractWindowPushRuntime.createBinaryComparators(this.partitionComparatorFactories);
        this.frameAccessor = new FrameTupleAccessor(this.inputRecordDesc);
        this.partitionColumnsRef = new PermutingFrameTupleReference(this.partitionColumns);
        this.partitionColumnsPrevCopy = PointableTupleReference.create((int)this.partitionColumns.length, ArrayBackedValueStorage::new);
        IBinaryComparator[] orderComparators = AbstractWindowPushRuntime.createBinaryComparators(this.orderComparatorFactories);
        for (IWindowAggregateEvaluator runningAggEval : this.runningAggEvals) {
            runningAggEval.configure(orderComparators);
        }
    }

    @Override
    public void close() throws HyracksDataException {
        if (this.inPartition && !this.failed) {
            this.endPartition();
        }
        super.close();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.frameAccessor.reset(buffer);
        int nTuple = this.frameAccessor.getTupleCount();
        if (nTuple == 0) {
            return;
        }
        if (this.frameId == 0L) {
            this.beginPartition();
        } else {
            boolean samePartition = PreclusteredGroupWriter.sameGroup((ITupleReference)this.partitionColumnsPrevCopy, (IFrameTupleAccessor)this.frameAccessor, (int)0, (int[])this.partitionColumns, (IBinaryComparator[])this.partitionComparators);
            if (!samePartition) {
                this.endPartition();
                this.beginPartition();
            }
        }
        int tLastIndex = nTuple - 1;
        if (tLastIndex == 0) {
            this.partitionChunk(this.frameId, buffer, 0, 0);
        } else {
            int tBeginIndex = 0;
            for (int tIndex = 1; tIndex <= tLastIndex; ++tIndex) {
                this.partitionColumnsRef.reset((IFrameTupleAccessor)this.frameAccessor, tIndex - 1);
                boolean samePartition = PreclusteredGroupWriter.sameGroup((ITupleReference)this.partitionColumnsRef, (IFrameTupleAccessor)this.frameAccessor, (int)tIndex, (int[])this.partitionColumns, (IBinaryComparator[])this.partitionComparators);
                if (samePartition) continue;
                this.partitionChunk(this.frameId, buffer, tBeginIndex, tIndex - 1);
                this.endPartition();
                this.beginPartition();
                tBeginIndex = tIndex;
            }
            this.partitionChunk(this.frameId, buffer, tBeginIndex, tLastIndex);
        }
        this.partitionColumnsRef.reset((IFrameTupleAccessor)this.frameAccessor, tLastIndex);
        this.partitionColumnsPrevCopy.set((ITupleReference)this.partitionColumnsRef);
        ++this.frameId;
    }

    private void beginPartition() throws HyracksDataException {
        if (this.inPartition) {
            throw new IllegalStateException();
        }
        this.inPartition = true;
        this.beginPartitionImpl();
    }

    private void partitionChunk(long frameId, ByteBuffer frameBuffer, int beginTupleIdx, int endTupleIdx) throws HyracksDataException {
        if (!this.inPartition || frameId < 0L) {
            throw new IllegalStateException();
        }
        this.partitionChunkImpl(frameId, frameBuffer, beginTupleIdx, endTupleIdx);
    }

    private void endPartition() throws HyracksDataException {
        if (!this.inPartition) {
            throw new IllegalStateException();
        }
        this.endPartitionImpl();
        this.inPartition = false;
    }

    void runningAggInitPartition(long partitionLength) throws HyracksDataException {
        for (IWindowAggregateEvaluator runningAggEval : this.runningAggEvals) {
            runningAggEval.initPartition(partitionLength);
        }
    }

    static IBinaryComparator[] createBinaryComparators(IBinaryComparatorFactory[] factories) {
        IBinaryComparator[] comparators = new IBinaryComparator[factories.length];
        for (int i = 0; i < factories.length; ++i) {
            comparators[i] = factories[i].createBinaryComparator();
        }
        return comparators;
    }

    protected abstract void beginPartitionImpl() throws HyracksDataException;

    protected abstract void partitionChunkImpl(long var1, ByteBuffer var3, int var4, int var5) throws HyracksDataException;

    protected abstract void endPartitionImpl() throws HyracksDataException;
}

