/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients.aws.s3;

import java.util.Map;
import org.apache.asterix.common.config.CloudProperties;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public final class S3ClientConfig {
    static final int DELETE_BATCH_SIZE = 1000;
    private final String region;
    private final String endpoint;
    private final String prefix;
    private final boolean anonymousAuth;
    private final long profilerLogInterval;

    public S3ClientConfig(String region, String endpoint, String prefix, boolean anonymousAuth, long profilerLogInterval) {
        this.region = region;
        this.endpoint = endpoint;
        this.prefix = prefix;
        this.anonymousAuth = anonymousAuth;
        this.profilerLogInterval = profilerLogInterval;
    }

    public static S3ClientConfig of(CloudProperties cloudProperties) {
        return new S3ClientConfig(cloudProperties.getStorageRegion(), cloudProperties.getStorageEndpoint(), cloudProperties.getStoragePrefix(), cloudProperties.isStorageAnonymousAuth(), cloudProperties.getProfilerLogInterval());
    }

    public static S3ClientConfig of(Map<String, String> configuration) {
        String endPoint = configuration.getOrDefault("serviceEndpoint", "");
        long profilerLogInterval = 0L;
        String region = "";
        String prefix = "";
        boolean anonymousAuth = false;
        return new S3ClientConfig(region, endPoint, prefix, anonymousAuth, profilerLogInterval);
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isLocalS3Provider() {
        return this.isS3Mock();
    }

    public AwsCredentialsProvider createCredentialsProvider() {
        return this.anonymousAuth ? AnonymousCredentialsProvider.create() : DefaultCredentialsProvider.builder().build();
    }

    public long getProfilerLogInterval() {
        return this.profilerLogInterval;
    }

    private boolean isS3Mock() {
        return this.endpoint != null && !this.endpoint.isEmpty();
    }
}

