/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.cloud.CloudFileHandle;
import org.apache.asterix.cloud.CloudResettableInputStream;
import org.apache.asterix.cloud.IWriteBufferProvider;
import org.apache.asterix.cloud.WriteBufferProvider;
import org.apache.asterix.cloud.bulk.DeleteBulkCloudOperation;
import org.apache.asterix.cloud.bulk.NoOpDeleteBulkCallBack;
import org.apache.asterix.cloud.clients.CloudClientProvider;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.util.CloudFileUtil;
import org.apache.asterix.common.api.INamespacePathResolver;
import org.apache.asterix.common.cloud.IPartitionBootstrapper;
import org.apache.asterix.common.config.CloudProperties;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOBulkOperation;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCloudIOManager
extends IOManager
implements IPartitionBootstrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String metadataNamespacePath;
    protected final ICloudClient cloudClient;
    protected final IWriteBufferProvider writeBufferProvider;
    protected final String bucket;
    protected final Set<Integer> partitions;
    protected final List<FileReference> partitionPaths;
    protected final IOManager localIoManager;

    public AbstractCloudIOManager(IOManager ioManager, CloudProperties cloudProperties, INamespacePathResolver nsPathResolver) throws HyracksDataException {
        super(ioManager.getIODevices(), ioManager.getDeviceComputer(), ioManager.getIOParallelism(), ioManager.getQueueSize());
        this.metadataNamespacePath = FileUtil.joinPath((String[])new String[]{"storage", "partition_-1", nsPathResolver.resolve(MetadataConstants.METADATA_NAMESPACE)});
        this.bucket = cloudProperties.getStorageBucket();
        this.cloudClient = CloudClientProvider.getClient(cloudProperties);
        int numOfThreads = this.getIODevices().size() * this.getIOParallelism();
        this.writeBufferProvider = new WriteBufferProvider(numOfThreads);
        this.partitions = new HashSet<Integer>();
        this.partitionPaths = new ArrayList<FileReference>();
        this.localIoManager = ioManager;
    }

    public IRecoveryManager.SystemState getSystemStateOnMissingCheckpoint() {
        if (this.cloudClient.listObjects(this.bucket, this.metadataNamespacePath, IoUtil.NO_OP_FILTER).isEmpty()) {
            LOGGER.info("First time to initialize this cluster: systemState = PERMANENT_DATA_LOSS");
            return IRecoveryManager.SystemState.PERMANENT_DATA_LOSS;
        }
        LOGGER.info("Resuming a previous initialized cluster: systemState = HEALTHY");
        return IRecoveryManager.SystemState.HEALTHY;
    }

    public final void bootstrap(Set<Integer> activePartitions, List<FileReference> currentOnDiskPartitions, boolean metadataNode, int metadataPartition, boolean cleanup) throws HyracksDataException {
        this.partitions.clear();
        this.partitions.addAll(activePartitions);
        if (metadataNode) {
            this.partitions.add(metadataPartition);
        }
        this.partitionPaths.clear();
        for (Integer partition : activePartitions) {
            String partitionDir = "partition_" + partition;
            this.partitionPaths.add(this.resolve("storage" + File.separator + partitionDir));
        }
        LOGGER.warn("Initializing cloud manager with storage partitions: {}", this.partitions);
        if (cleanup) {
            this.deleteUnkeptPartitionDirs(currentOnDiskPartitions);
            this.cleanupLocalFiles();
        }
        this.downloadPartitions(metadataNode, metadataPartition);
    }

    private void deleteUnkeptPartitionDirs(List<FileReference> currentOnDiskPartitions) throws HyracksDataException {
        for (FileReference partitionDir : currentOnDiskPartitions) {
            int partitionNum = StoragePathUtil.getPartitionNumFromRelativePath((String)partitionDir.getRelativePath());
            if (this.partitions.contains(partitionNum)) continue;
            LOGGER.warn("Deleting storage partition {} as it does not belong to the current storage partitions {}", (Object)partitionNum, this.partitions);
            this.localIoManager.delete(partitionDir);
        }
    }

    private void cleanupLocalFiles() throws HyracksDataException {
        Set<String> cloudFiles = this.cloudClient.listObjects(this.bucket, "storage", IoUtil.NO_OP_FILTER);
        if (cloudFiles.isEmpty()) {
            LOGGER.warn("No files in the cloud. Deleting all local files in partitions {}...", this.partitions);
            for (FileReference partitionPath : this.partitionPaths) {
                if (!this.localIoManager.exists(partitionPath)) continue;
                this.localIoManager.cleanDirectory(partitionPath);
            }
        } else {
            LOGGER.info("Cleaning node partitions...");
            for (FileReference partitionPath : this.partitionPaths) {
                CloudFileUtil.cleanDirectoryFiles(this.localIoManager, cloudFiles, partitionPath);
            }
        }
    }

    protected abstract void downloadPartitions(boolean var1, int var2) throws HyracksDataException;

    public final IFileHandle open(FileReference fileRef, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
        CloudFileHandle fHandle = new CloudFileHandle(this.cloudClient, this.bucket, fileRef, this.writeBufferProvider);
        this.onOpen(fHandle, rwMode, syncMode);
        try {
            fHandle.open(rwMode, syncMode);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return fHandle;
    }

    protected abstract void onOpen(CloudFileHandle var1, IIOManager.FileReadWriteMode var2, IIOManager.FileSyncMode var3) throws HyracksDataException;

    public final long doSyncWrite(IFileHandle fHandle, long offset, ByteBuffer[] dataArray) throws HyracksDataException {
        long writtenBytes = this.localIoManager.doSyncWrite(fHandle, offset, dataArray);
        CloudResettableInputStream inputStream = ((CloudFileHandle)fHandle).getInputStream();
        try {
            inputStream.write(dataArray[0], dataArray[1]);
        }
        catch (HyracksDataException e) {
            inputStream.abort();
            throw e;
        }
        return writtenBytes;
    }

    public final int doSyncWrite(IFileHandle fHandle, long offset, ByteBuffer dataArray) throws HyracksDataException {
        int writtenBytes = this.localIoManager.doSyncWrite(fHandle, offset, dataArray);
        CloudResettableInputStream inputStream = ((CloudFileHandle)fHandle).getInputStream();
        try {
            inputStream.write(dataArray);
        }
        catch (HyracksDataException e) {
            inputStream.abort();
            throw e;
        }
        return writtenBytes;
    }

    public IIOBulkOperation createDeleteBulkOperation() {
        return new DeleteBulkCloudOperation(this.localIoManager, this.bucket, this.cloudClient, NoOpDeleteBulkCallBack.INSTANCE);
    }

    public final void close(IFileHandle fHandle) throws HyracksDataException {
        try {
            CloudFileHandle cloudFileHandle = (CloudFileHandle)fHandle;
            cloudFileHandle.close();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public final void sync(IFileHandle fileHandle, boolean metadata) throws HyracksDataException {
        HyracksDataException savedEx = null;
        if (metadata) {
            CloudResettableInputStream stream = ((CloudFileHandle)fileHandle).getInputStream();
            try {
                stream.finish();
            }
            catch (HyracksDataException e) {
                savedEx = e;
            }
            if (savedEx != null) {
                try {
                    stream.abort();
                }
                catch (HyracksDataException e) {
                    savedEx.addSuppressed((Throwable)e);
                }
                throw savedEx;
            }
        }
        this.localIoManager.sync(fileHandle, metadata);
    }

    public final void create(FileReference fileRef) throws HyracksDataException {
        this.localIoManager.delete(fileRef);
        this.localIoManager.create(fileRef);
    }

    public final void copyDirectory(FileReference srcFileRef, FileReference destFileRef) throws HyracksDataException {
        this.cloudClient.copy(this.bucket, srcFileRef.getRelativePath(), destFileRef);
        this.localIoManager.copyDirectory(srcFileRef, destFileRef);
    }

    public final void close() throws IOException {
        this.cloudClient.close();
        super.close();
        this.localIoManager.close();
    }

    public final JsonNode listAsJson(ObjectMapper objectMapper) {
        return this.cloudClient.listAsJson(objectMapper, this.bucket);
    }

    public final void put(String key, byte[] bytes) {
        this.cloudClient.write(this.bucket, key, bytes);
    }
}

