/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.storage.ResourceReference;

public class DatasetCopyIdentifier
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String database;
    private final DataverseName dataverse;
    private final String dataset;
    private final String rebalance;

    private DatasetCopyIdentifier(String database, DataverseName dataverse, String datasetName, String rebalance) {
        this.database = database;
        this.dataverse = dataverse;
        this.dataset = datasetName;
        this.rebalance = rebalance;
    }

    public static DatasetCopyIdentifier of(String database, DataverseName dataverse, String datasetName, String rebalance) {
        return new DatasetCopyIdentifier(database, dataverse, datasetName, rebalance);
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getRebalance() {
        return this.rebalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetCopyIdentifier that = (DatasetCopyIdentifier)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.dataverse, that.dataverse) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.rebalance, that.rebalance);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.dataverse, this.dataset, this.rebalance);
    }

    public DataverseName getDataverse() {
        return this.dataverse;
    }

    public boolean isMatch(ResourceReference resourceReference) {
        return resourceReference.getDatabase().equals(this.database) && resourceReference.getDataverse().equals(this.dataverse) && resourceReference.getDataset().equals(this.dataset) && resourceReference.getRebalance().equals(this.rebalance);
    }

    public String toString() {
        return "DatasetCopyIdentifier{dataset='" + this.dataset + "', dataverse='" + this.dataverse + "', rebalance='" + this.rebalance + "'}";
    }
}

