/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.FeedConnectionEntity;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedConnectionTupleTranslator
extends AbstractTupleTranslator<FeedConnection> {
    private final FeedConnectionEntity feedConnectionEntity;

    public FeedConnectionTupleTranslator(boolean getTuple, FeedConnectionEntity feedConnectionEntity) {
        super(getTuple, feedConnectionEntity.getIndex(), feedConnectionEntity.payloadPosition());
        this.feedConnectionEntity = feedConnectionEntity;
    }

    @Override
    protected FeedConnection createMetadataEntityFromARecord(ARecord feedConnectionRecord) throws AlgebricksException {
        int whereClauseIdx;
        String dataverseCanonicalName = ((AString)feedConnectionRecord.getValueByPos(this.feedConnectionEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.feedConnectionEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)feedConnectionRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String feedName = ((AString)feedConnectionRecord.getValueByPos(this.feedConnectionEntity.feedNameIndex())).getStringValue();
        String datasetName = ((AString)feedConnectionRecord.getValueByPos(this.feedConnectionEntity.datasetNameIndex())).getStringValue();
        String outputType = ((AString)feedConnectionRecord.getValueByPos(this.feedConnectionEntity.outputTypeIndex())).getStringValue();
        String policyName = ((AString)feedConnectionRecord.getValueByPos(this.feedConnectionEntity.policyIndex())).getStringValue();
        ArrayList<FunctionSignature> appliedFunctions = null;
        IAObject o = feedConnectionRecord.getValueByPos(this.feedConnectionEntity.appliedFunctionsIndex());
        if (!(o instanceof ANull) && !(o instanceof AMissing)) {
            appliedFunctions = new ArrayList<FunctionSignature>();
            AUnorderedList afList = (AUnorderedList)feedConnectionRecord.getValueByPos(this.feedConnectionEntity.appliedFunctionsIndex());
            IACursor cursor = afList.getCursor();
            while (cursor.next()) {
                String afValue = ((AString)cursor.get()).getStringValue();
                int pos = afValue.lastIndexOf(46);
                String afDataverseCanonicalName = afValue.substring(0, pos);
                String afName = afValue.substring(pos + 1);
                DataverseName afDataverseName = DataverseName.createFromCanonicalForm((String)afDataverseCanonicalName);
                String afDatabaseName = MetadataUtil.databaseFor((DataverseName)afDataverseName);
                FunctionSignature functionSignature = new FunctionSignature(afDatabaseName, afDataverseName, afName, 1);
                appliedFunctions.add(functionSignature);
            }
        }
        String whereClauseBody = (whereClauseIdx = feedConnectionRecord.getType().getFieldIndex("WhereClause")) >= 0 ? ((AString)feedConnectionRecord.getValueByPos(whereClauseIdx)).getStringValue() : "";
        return new FeedConnection(databaseName, dataverseName, feedName, datasetName, appliedFunctions, policyName, whereClauseBody, outputType);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FeedConnection feedConnection) throws HyracksDataException {
        String dataverseCanonicalName = feedConnection.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.feedConnectionEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(feedConnection.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feedConnection.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feedConnection.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.feedConnectionEntity.getRecordType());
        if (this.feedConnectionEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(feedConnection.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.feedConnectionEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedConnectionEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedConnectionEntity.feedNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedConnectionEntity.datasetNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getOutputType());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedConnectionEntity.outputTypeIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.writeAppliedFunctionsField(this.recordBuilder, feedConnection, this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedConnection.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedConnectionEntity.policyIndex(), (IValueReference)this.fieldValue);
        this.writeOpenFields(feedConnection);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(FeedConnection feedConnection) throws HyracksDataException {
        this.writeWhereClauseBody(feedConnection);
    }

    private void writeWhereClauseBody(FeedConnection feedConnection) throws HyracksDataException {
        if (feedConnection.getWhereClauseBody() != null && feedConnection.getWhereClauseBody().length() > 0) {
            this.fieldName.reset();
            this.aString.setValue("WhereClause");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(feedConnection.getWhereClauseBody());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    private void writeAppliedFunctionsField(IARecordBuilder rb, FeedConnection fc, ArrayBackedValueStorage buffer) throws HyracksDataException {
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        ArrayBackedValueStorage listEleBuffer = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AUnorderedListType)this.feedConnectionEntity.getRecordType().getFieldTypes()[this.feedConnectionEntity.appliedFunctionsIndex()]));
        if (fc.getAppliedFunctions() != null) {
            List<FunctionSignature> appliedFunctions = fc.getAppliedFunctions();
            for (FunctionSignature af : appliedFunctions) {
                listEleBuffer.reset();
                this.aString.setValue(af.getDataverseName().getCanonicalForm() + "." + af.getName());
                this.stringSerde.serialize((Object)this.aString, listEleBuffer.getDataOutput());
                listBuilder.addItem((IValueReference)listEleBuffer);
            }
        }
        listBuilder.write(buffer.getDataOutput(), true);
        rb.addField(this.feedConnectionEntity.appliedFunctionsIndex(), (IValueReference)buffer);
    }
}

