/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class SynonymEntity {
    private static final SynonymEntity SYNONYM = new SynonymEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_SYNONYM, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("SynonymName")), 0, SynonymEntity.synonymType(), true, new int[]{0, 1}), 2, -1);
    private static final SynonymEntity DB_SYNONYM = new SynonymEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_SYNONYM, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("SynonymName")), 0, SynonymEntity.databaseSynonymType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int synonymNameIndex;
    private final int objectDataverseNameIndex;
    private final int objectNameIndex;

    private SynonymEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.synonymNameIndex = startIndex++;
        this.objectDataverseNameIndex = startIndex++;
        this.objectNameIndex = startIndex++;
    }

    public static SynonymEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_SYNONYM : SYNONYM;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int synonymNameIndex() {
        return this.synonymNameIndex;
    }

    public int objectDataverseNameIndex() {
        return this.objectDataverseNameIndex;
    }

    public int objectNameIndex() {
        return this.objectNameIndex;
    }

    private static ARecordType synonymType() {
        return MetadataRecordTypes.createRecordType("SynonymRecordType", new String[]{"DataverseName", "SynonymName", "ObjectDataverseName", "ObjectName"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseSynonymType() {
        return MetadataRecordTypes.createRecordType("SynonymRecordType", new String[]{"DatabaseName", "DataverseName", "SynonymName", "ObjectDataverseName", "ObjectName"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }
}

