/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class NodeEntity {
    private static final NodeEntity NODE = new NodeEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_NODE, 2, new IAType[]{BuiltinType.ASTRING}, List.of(List.of("NodeName")), 0, NodeEntity.nodeType(), true, new int[]{0}), 1, -1);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int nodeNameIndex;
    private final int numberOfCoresIndex;
    private final int memorySizeIndex;

    private NodeEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.nodeNameIndex = startIndex++;
        this.numberOfCoresIndex = startIndex++;
        this.memorySizeIndex = startIndex++;
    }

    public static NodeEntity of(boolean cloudDeployment) {
        return NODE;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int nodeNameIndex() {
        return this.nodeNameIndex;
    }

    public int numberOfCoresIndex() {
        return this.numberOfCoresIndex;
    }

    public int memorySizeIndex() {
        return this.memorySizeIndex;
    }

    private static ARecordType nodeType() {
        return MetadataRecordTypes.createRecordType("NodeRecordType", new String[]{"NodeName", "NumberOfCores", "WorkingMemorySize"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.AINT64, BuiltinType.AINT64}, true);
    }
}

