/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class CompactionPolicyEntity {
    private static final CompactionPolicyEntity COMPACTION_POLICY = new CompactionPolicyEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_COMPACTION_POLICY, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("CompactionPolicy")), 0, CompactionPolicyEntity.compactionPolicyType(), true, new int[]{0, 1}), 2, -1);
    private static final CompactionPolicyEntity DB_COMPACTION_POLICY = new CompactionPolicyEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_COMPACTION_POLICY, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("CompactionPolicy")), 0, CompactionPolicyEntity.databaseCompactionPolicyType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int policyNameIndex;
    private final int classNameIndex;

    private CompactionPolicyEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.policyNameIndex = startIndex++;
        this.classNameIndex = startIndex++;
    }

    public static CompactionPolicyEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_COMPACTION_POLICY : COMPACTION_POLICY;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int policyNameIndex() {
        return this.policyNameIndex;
    }

    public int classNameIndex() {
        return this.classNameIndex;
    }

    private static ARecordType compactionPolicyType() {
        return MetadataRecordTypes.createRecordType("CompactionPolicyRecordType", new String[]{"DataverseName", "CompactionPolicy", "Classname"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseCompactionPolicyType() {
        return MetadataRecordTypes.createRecordType("CompactionPolicyRecordType", new String[]{"DatabaseName", "DataverseName", "CompactionPolicy", "Classname"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }
}

