/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.logging.LogManager;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.logging.log4j.Logger;

public class LogManagerWithReplication
extends LogManager {
    private static final Logger LOGGER = org.apache.logging.log4j.LogManager.getLogger();
    private IReplicationManager replicationManager;
    private IReplicationStrategy replicationStrategy;
    private final LongSet replicatedTxn = LongSets.synchronize((LongSet)new LongOpenHashSet());
    private final long replicationTimeoutMillis;

    public LogManagerWithReplication(ITransactionSubsystem txnSubsystem) {
        super(txnSubsystem);
        this.replicationTimeoutMillis = TimeUnit.SECONDS.toMillis(txnSubsystem.getApplicationContext().getReplicationProperties().getReplicationTimeOut());
    }

    @Override
    public void log(ILogRecord logRecord) {
        boolean shouldReplicate;
        boolean bl = shouldReplicate = logRecord.getLogSource() == 0 && logRecord.getLogType() != 6 && logRecord.getLogType() != 9;
        if (shouldReplicate) {
            switch (logRecord.getLogType()) {
                case 0: 
                case 2: 
                case 4: 
                case 7: {
                    shouldReplicate = this.replicationStrategy.isMatch(logRecord.getDatasetId());
                    if (!shouldReplicate) break;
                    this.replicatedTxn.add(logRecord.getTxnId());
                    break;
                }
                case 1: 
                case 3: {
                    shouldReplicate = this.replicatedTxn.remove(logRecord.getTxnId());
                    break;
                }
                default: {
                    shouldReplicate = false;
                }
            }
        }
        logRecord.setReplicate(shouldReplicate);
        if (!this.logToFlushQueue(logRecord)) {
            this.appendToLogTail(logRecord);
        }
    }

    @Override
    protected void appendToLogTail(ILogRecord logRecord) {
        this.syncAppendToLogTail(logRecord);
        if (logRecord.isReplicate()) {
            try {
                this.replicationManager.replicate(logRecord);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ACIDException((Throwable)e);
            }
        }
        if (logRecord.getLogSource() == 0 && LogManagerWithReplication.waitForFlush(logRecord) && !logRecord.isFlushed()) {
            InvokeUtil.doUninterruptibly(() -> {
                ILogRecord iLogRecord = logRecord;
                synchronized (iLogRecord) {
                    while (!logRecord.isFlushed()) {
                        logRecord.wait();
                    }
                    if (logRecord.isReplicate() && (logRecord.getLogType() == 1 || logRecord.getLogType() == 3)) {
                        long replicationTimeOut = this.replicationTimeoutMillis;
                        while (!logRecord.isReplicated()) {
                            if (replicationTimeOut <= 0L) {
                                LOGGER.warn("{} ms passed without receiving acks for log {}; setting log as replicated due to timeout", (Object)this.replicationTimeoutMillis, (Object)logRecord.getLogRecordForDisplay());
                                logRecord.setReplicated(true);
                                continue;
                            }
                            long startTime = System.nanoTime();
                            logRecord.wait(replicationTimeOut);
                            replicationTimeOut -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void setReplicationManager(IReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
        this.replicationStrategy = replicationManager.getReplicationStrategy();
    }
}

