/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropIndexTask
implements IReplicaTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String file;

    public DropIndexTask(String file) {
        this.file = file;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            IIOManager ioManager = appCtx.getIoManager();
            FileReference indexFile = ioManager.resolve(this.file);
            if (ioManager.exists(indexFile)) {
                FileReference indexDir = indexFile.getParent();
                ioManager.delete(indexDir);
                ((PersistentLocalResourceRepository)appCtx.getLocalResourceRepository()).invalidateResource(ResourceReference.of((String)this.file).getRelativePath().toString());
                LOGGER.info(() -> "Deleted index: " + indexFile.getAbsolutePath());
            } else {
                LOGGER.warn(() -> "Requested to delete a non-existing index: " + indexFile.getAbsolutePath());
            }
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.DROP_INDEX;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static DropIndexTask create(DataInput input) throws IOException {
        return new DropIndexTask(input.readUTF());
    }
}

