/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.MergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.AbstractLSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesFlushCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.TreeTupleSorter;
import org.apache.hyracks.storage.am.rtree.frames.RTreeFrameFactory;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.IndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMRTreeWithAntiMatterTuples
extends AbstractLSMRTree {
    private static final LSMTreeIndexAccessor.ICursorFactory cursorFactory = opCtx -> new LSMRTreeWithAntiMatterTuplesSearchCursor(opCtx);

    public LSMRTreeWithAntiMatterTuples(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, RTreeFrameFactory rtreeInteriorFrameFactory, RTreeFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeComparatorFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, int[] rtreeFields, int[] filterFields, boolean durable, boolean isPointMBR) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, diskBufferCache, fileManager, componentFactory, bulkLoadComponentFactory, fieldCount, rtreeCmpFactories, btreeComparatorFactories, linearizer, comparatorFields, linearizerArray, 0.0, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, filterHelper, filterFrameFactory, filterManager, rtreeFields, filterFields, durable, isPointMBR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doFlush(ILSMIOOperation operation) throws HyracksDataException {
        LSMRTreeFlushOperation flushOp = (LSMRTreeFlushOperation)operation;
        LSMRTreeMemoryComponent flushingComponent = (LSMRTreeMemoryComponent)flushOp.getFlushingComponent();
        SearchPredicate rtreeNullPredicate = new SearchPredicate(null, null);
        ILSMDiskComponent component = null;
        ILSMDiskComponentBulkLoader componentBulkLoader = null;
        TreeTupleSorter rTreeTupleSorter = null;
        TreeTupleSorter bTreeTupleSorter = null;
        boolean isEmpty = true;
        boolean abort = true;
        try {
            RTree.RTreeAccessor memRTreeAccessor = flushingComponent.getIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            try {
                RTreeSearchCursor rtreeScanCursor = memRTreeAccessor.createSearchCursor(false);
                try {
                    memRTreeAccessor.search((IIndexCursor)rtreeScanCursor, (ISearchPredicate)rtreeNullPredicate);
                    component = this.createDiskComponent(this.componentFactory, flushOp.getTarget(), null, null, true);
                    componentBulkLoader = component.createBulkLoader(operation, 1.0f, false, 0L, false, false, false, this.pageWriteCallbackFactory.createPageWriteCallback());
                    rTreeTupleSorter = new TreeTupleSorter(flushingComponent.getIndex().getFileId(), this.linearizerArray, this.rtreeLeafFrameFactory.createFrame(), this.rtreeLeafFrameFactory.createFrame(), flushingComponent.getIndex().getBufferCache(), this.comparatorFields);
                    try {
                        isEmpty = this.scanAndSort(rtreeScanCursor, rTreeTupleSorter);
                    }
                    finally {
                        rtreeScanCursor.close();
                    }
                }
                finally {
                    rtreeScanCursor.destroy();
                }
            }
            finally {
                memRTreeAccessor.destroy();
            }
            if (!isEmpty) {
                rTreeTupleSorter.sort();
            }
            RangePredicate btreeNullPredicate = new RangePredicate(null, null, true, true, null, null);
            BTree.BTreeAccessor memBTreeAccessor = flushingComponent.getBuddyIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            try {
                bTreeTupleSorter = new TreeTupleSorter(flushingComponent.getBuddyIndex().getFileId(), this.linearizerArray, this.btreeLeafFrameFactory.createFrame(), this.btreeLeafFrameFactory.createFrame(), flushingComponent.getBuddyIndex().getBufferCache(), this.comparatorFields);
                BTreeRangeSearchCursor btreeScanCursor = (BTreeRangeSearchCursor)memBTreeAccessor.createSearchCursor(false);
                try {
                    isEmpty = true;
                    memBTreeAccessor.search((IIndexCursor)btreeScanCursor, (ISearchPredicate)btreeNullPredicate);
                    try {
                        isEmpty = this.scanAndSort(btreeScanCursor, bTreeTupleSorter);
                    }
                    finally {
                        btreeScanCursor.close();
                    }
                }
                finally {
                    btreeScanCursor.destroy();
                }
            }
            finally {
                memBTreeAccessor.destroy();
            }
            if (!isEmpty) {
                bTreeTupleSorter.sort();
            }
            LSMRTreeWithAntiMatterTuplesFlushCursor cursor = new LSMRTreeWithAntiMatterTuplesFlushCursor(rTreeTupleSorter, bTreeTupleSorter, this.comparatorFields, this.linearizerArray);
            try {
                cursor.open(null, null);
                try {
                    while (cursor.hasNext()) {
                        cursor.next();
                        ITupleReference frameTuple = cursor.getTuple();
                        componentBulkLoader.add(frameTuple);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            finally {
                cursor.destroy();
            }
            if (component.getLSMComponentFilter() != null) {
                ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
                filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
                filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
                this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
                this.getFilterManager().writeFilter(component.getLSMComponentFilter(), component.getMetadataHolder());
            }
            flushingComponent.getMetadata().copy(component.getMetadata());
            abort = false;
            componentBulkLoader.end();
        }
        finally {
            try {
                if (rTreeTupleSorter != null) {
                    rTreeTupleSorter.destroy();
                }
            }
            finally {
                try {
                    if (bTreeTupleSorter != null) {
                        bTreeTupleSorter.destroy();
                    }
                }
                finally {
                    if (abort && componentBulkLoader != null) {
                        componentBulkLoader.abort();
                    }
                }
            }
        }
        return component;
    }

    private boolean scanAndSort(RTreeSearchCursor scanCursor, TreeTupleSorter tupleSorter) throws HyracksDataException {
        boolean isEmpty = true;
        while (scanCursor.hasNext()) {
            isEmpty = false;
            scanCursor.next();
            tupleSorter.insertTupleEntry(scanCursor.getPageId(), scanCursor.getTupleOffset());
        }
        return isEmpty;
    }

    private boolean scanAndSort(BTreeRangeSearchCursor scanCursor, TreeTupleSorter tupleSorter) throws HyracksDataException {
        boolean isEmpty = true;
        while (scanCursor.hasNext()) {
            isEmpty = false;
            scanCursor.next();
            tupleSorter.insertTupleEntry(scanCursor.getPageId(), scanCursor.getTupleOffset());
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doMerge(ILSMIOOperation operation) throws HyracksDataException {
        MergeOperation mergeOp = (MergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        this.search(opCtx, cursor, (ISearchPredicate)rtreeSearchPred);
        ILSMDiskComponent component = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), null, null, true);
        ILSMDiskComponentBulkLoader componentBulkLoader = component.createBulkLoader(operation, 1.0f, false, 0L, false, false, false, this.pageWriteCallbackFactory.createPageWriteCallback());
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple());
                filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple());
            }
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), component.getMetadataHolder());
        }
        componentBulkLoader.end();
        return component;
    }

    public ILSMIndexAccessor createAccessor(IIndexAccessParameters iap) {
        LSMRTreeOpContext opCtx = this.createOpContext(iap);
        return new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
        return new LSMRTreeFlushOperation((ILSMIndexAccessor)accessor, componentFileRefs.getInsertIndexFileReference(), null, null, callback, this.getIndexIdentifier());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        boolean returnDeletedTuples = false;
        List mergingComponents = opCtx.getComponentHolder();
        if (mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        IndexCursorStats stats = new IndexCursorStats();
        LSMRTreeWithAntiMatterTuplesSearchCursor cursor = new LSMRTreeWithAntiMatterTuplesSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples, (IIndexCursorStats)stats);
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
        return new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, (IIndexCursor)cursor, (IIndexCursorStats)stats, mergeFileRefs.getInsertIndexFileReference(), null, null, callback, this.getIndexIdentifier());
    }
}

