/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io.profiling;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.control.nc.io.profiling.IOCounterCache;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOCounterProc
extends IOCounterCache<List<String>> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File STATFILE = new File("/proc/self/io");
    private long failureCount;

    @Override
    public long getReads() {
        try {
            return this.extractRow((List)this.getInfo(), 4);
        }
        catch (Exception e) {
            LOGGER.log(this.failureCount++ > 0L ? Level.DEBUG : Level.WARN, "Failure getting reads", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public long getWrites() {
        try {
            List rows = (List)this.getInfo();
            return this.extractRow(rows, 5);
        }
        catch (Exception e) {
            LOGGER.log(this.failureCount++ > 0L ? Level.DEBUG : Level.WARN, "Failure getting writes", (Throwable)e);
            return -1L;
        }
    }

    private long extractRow(List<String> rows, int rowIndex) {
        return Long.parseLong(StringUtils.split((String)rows.get(rowIndex), (char)' ')[1]);
    }

    @Override
    protected List<String> calculateInfo() throws IOException {
        return FileUtils.readLines((File)STATFILE, (Charset)Charset.defaultCharset());
    }
}

