/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;

public class LSMBTreeFileManager
extends AbstractLSMIndexFileManager {
    private static final FilenameFilter BTREE_FILTER = (dir, name) -> !name.startsWith(".") && name.endsWith("b");
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final boolean hasBloomFilter;

    public LSMBTreeFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, boolean hasBloomFilter, ICompressorDecompressorFactory compressorDecompressorFactory) {
        super(ioManager, file, null, compressorDecompressorFactory);
        this.btreeFactory = btreeFactory;
        this.hasBloomFilter = hasBloomFilter;
    }

    public LSMBTreeFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, boolean hasBloomFilter) {
        this(ioManager, file, btreeFactory, hasBloomFilter, NoOpCompressorDecompressorFactory.INSTANCE);
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String baseName = this.getNextComponentSequence(BTREE_FILTER);
        return new LSMComponentFileReferences(this.getCompressedFileReferenceIfAny(baseName + "_b"), null, this.hasBloomFilter ? this.getCompressedFileReferenceIfAny(baseName + "_f") : null);
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) {
        String baseName = IndexComponentFileReference.getMergeSequence((String)firstFileName, (String)lastFileName);
        return new LSMComponentFileReferences(this.getCompressedFileReferenceIfAny(baseName + "_b"), null, this.hasBloomFilter ? this.getCompressedFileReferenceIfAny(baseName + "_f") : null);
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        this.cleanupAndGetValidFilesInternal(BTREE_FILTER, this.btreeFactory, allBTreeFiles, this.btreeFactory.getBufferCache());
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (IndexComponentFileReference cmpFileName : allBTreeFiles) {
            int index = cmpFileName.getFileName().lastIndexOf("_");
            btreeFilesSet.add(cmpFileName.getFileName().substring(0, index));
        }
        this.cleanLookAsideFiles(btreeFilesSet, this.btreeFactory.getBufferCache());
        if (this.hasBloomFilter) {
            this.validateFiles(btreeFilesSet, allBloomFilterFiles, BLOOM_FILTER_FILTER, null, this.btreeFactory.getBufferCache());
            if (allBTreeFiles.size() != allBloomFilterFiles.size()) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.UNEQUAL_NUM_FILTERS_TREES, (Serializable[])new Serializable[]{this.baseDir});
            }
        }
        if (allBTreeFiles.isEmpty()) {
            return validFiles;
        }
        if (allBTreeFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((IndexComponentFileReference)allBTreeFiles.get(0)).getFileRef(), null, this.hasBloomFilter ? ((IndexComponentFileReference)allBloomFilterFiles.get(0)).getFileRef() : null));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        if (this.hasBloomFilter) {
            Collections.sort(allBloomFilterFiles);
        }
        ArrayList<IndexComponentFileReference> validComparableBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBTree = (IndexComponentFileReference)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<IndexComponentFileReference> validComparableBloomFilterFiles = null;
        IndexComponentFileReference lastBloomFilter = null;
        if (this.hasBloomFilter) {
            validComparableBloomFilterFiles = new ArrayList<IndexComponentFileReference>();
            lastBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(0);
            validComparableBloomFilterFiles.add(lastBloomFilter);
        }
        IndexComponentFileReference currentBloomFilter = null;
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            IndexComponentFileReference currentBTree = (IndexComponentFileReference)allBTreeFiles.get(i);
            if (this.hasBloomFilter) {
                currentBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(i);
            }
            if (currentBTree.isMoreRecentThan(lastBTree) && (!this.hasBloomFilter || currentBloomFilter.isMoreRecentThan(lastBloomFilter))) {
                validComparableBTreeFiles.add(currentBTree);
                lastBTree = currentBTree;
                if (!this.hasBloomFilter) continue;
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.isWithin(lastBTree) && (!this.hasBloomFilter || currentBloomFilter.isWithin(lastBloomFilter))) {
                this.delete(this.btreeFactory.getBufferCache(), currentBTree.getFileRef());
                if (!this.hasBloomFilter) continue;
                this.delete(this.btreeFactory.getBufferCache(), currentBloomFilter.getFileRef());
                continue;
            }
            throw HyracksDataException.create((ErrorCode)ErrorCode.FOUND_OVERLAPPING_LSM_FILES, (Serializable[])new Serializable[]{this.baseDir});
        }
        validComparableBTreeFiles.sort(this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator bloomFilterFileIter = null;
        if (this.hasBloomFilter) {
            validComparableBloomFilterFiles.sort(this.recencyCmp);
            bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        }
        IndexComponentFileReference cmpBTreeFileName = null;
        IndexComponentFileReference cmpBloomFilterFileName = null;
        while (btreeFileIter.hasNext() && (!this.hasBloomFilter || bloomFilterFileIter.hasNext())) {
            cmpBTreeFileName = (IndexComponentFileReference)btreeFileIter.next();
            if (this.hasBloomFilter) {
                cmpBloomFilterFileName = (IndexComponentFileReference)bloomFilterFileIter.next();
            }
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.getFileRef(), null, this.hasBloomFilter ? cmpBloomFilterFileName.getFileRef() : null));
        }
        return validFiles;
    }
}

