/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.util.LangRecordParseUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.object.base.AdmBigIntNode;
import org.apache.asterix.object.base.AdmDoubleNode;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class AnalyzeStatement
extends AbstractStatement {
    private static final String SAMPLE_FIELD_NAME = "sample";
    private static final String SAMPLE_LOW = "low";
    private static final String SAMPLE_MEDIUM = "medium";
    private static final String SAMPLE_HIGH = "high";
    private static final int SAMPLE_LOW_SIZE = 1063;
    private static final int SAMPLE_MEDIUM_SIZE = 4252;
    private static final int SAMPLE_HIGH_SIZE = 17008;
    private static final int SAMPLE_DEFAULT_SIZE = 1063;
    private static final String SAMPLE_SEED_FIELD_NAME = "sample-seed";
    private final Namespace namespace;
    private final String datasetName;
    private final AdmObjectNode options;

    public AnalyzeStatement(Namespace namespace, String datasetName, RecordConstructor options) throws CompilationException {
        this.namespace = namespace;
        this.datasetName = datasetName;
        this.options = options == null ? null : AnalyzeStatement.validateOptions(options);
    }

    private static AdmObjectNode validateOptions(RecordConstructor options) throws CompilationException {
        List<FieldBinding> fbList = options.getFbList();
        block8: for (int i = 0; i < fbList.size(); ++i) {
            FieldBinding binding = fbList.get(i);
            String key = LangRecordParseUtil.exprToStringLiteral(binding.getLeftExpr()).getStringValue();
            Expression value = binding.getRightExpr();
            switch (key) {
                case "sample": {
                    if (value.getKind() == Expression.Kind.LITERAL_EXPRESSION) continue block8;
                    throw new CompilationException(ErrorCode.INVALID_SAMPLE_SIZE, new Serializable[0]);
                }
                case "sample-seed": {
                    if (value.getKind() == Expression.Kind.LITERAL_EXPRESSION || value.getKind() == Expression.Kind.UNARY_EXPRESSION) continue block8;
                    throw new CompilationException(ErrorCode.INVALID_SAMPLE_SEED, new Serializable[0]);
                }
                default: {
                    throw new CompilationException(ErrorCode.INVALID_PARAM, new Serializable[]{key});
                }
            }
        }
        return ExpressionUtils.toNode(options);
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.ANALYZE;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public int getSampleSize() throws CompilationException {
        IAdmNode n = this.getOption(SAMPLE_FIELD_NAME);
        if (n == null) {
            return 1063;
        }
        switch (n.getType()) {
            case STRING: {
                String s = ((AdmStringNode)n).get();
                switch (s.toLowerCase(Locale.ROOT)) {
                    case "low": {
                        return 1063;
                    }
                    case "medium": {
                        return 4252;
                    }
                    case "high": {
                        return 17008;
                    }
                }
                throw new CompilationException(ErrorCode.INVALID_SAMPLE_SIZE, new Serializable[0]);
            }
            case BIGINT: {
                int v = (int)((AdmBigIntNode)n).get();
                if (!this.isValidSampleSize(v)) {
                    throw new CompilationException(ErrorCode.OUT_OF_RANGE_SAMPLE_SIZE, new Serializable[]{Integer.valueOf(1063), Integer.valueOf(17008)});
                }
                return v;
            }
            case DOUBLE: {
                int v = (int)((AdmDoubleNode)n).get();
                if (!this.isValidSampleSize(v)) {
                    throw new CompilationException(ErrorCode.OUT_OF_RANGE_SAMPLE_SIZE, new Serializable[]{Integer.valueOf(1063), Integer.valueOf(17008)});
                }
                return v;
            }
        }
        throw new CompilationException(ErrorCode.WITH_FIELD_MUST_BE_OF_TYPE, new Serializable[]{SAMPLE_FIELD_NAME, BuiltinType.ASTRING.getTypeName(), n.getType().toString()});
    }

    public long getOrCreateSampleSeed() throws AlgebricksException {
        IAdmNode n = this.getOption(SAMPLE_SEED_FIELD_NAME);
        return n != null ? this.getSampleSeed(n) : this.createSampleSeed();
    }

    private long getSampleSeed(IAdmNode n) throws CompilationException {
        switch (n.getType()) {
            case BIGINT: {
                return ((AdmBigIntNode)n).get();
            }
            case DOUBLE: {
                return (long)((AdmDoubleNode)n).get();
            }
            case STRING: {
                String s = ((AdmStringNode)n).get();
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    throw new CompilationException(ErrorCode.INVALID_SAMPLE_SEED, new Serializable[0]);
                }
            }
        }
        throw new CompilationException(ErrorCode.WITH_FIELD_MUST_BE_OF_TYPE, new Serializable[]{SAMPLE_SEED_FIELD_NAME, BuiltinType.AINT64.getTypeName(), n.getType().toString()});
    }

    private long createSampleSeed() {
        return System.nanoTime() + (long)System.identityHashCode(this);
    }

    private boolean isValidSampleSize(int v) {
        return v >= 1063 && v <= 17008;
    }

    private IAdmNode getOption(String optionName) {
        return this.options != null ? this.options.get(optionName) : null;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

