/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IDataFlowController;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordDataParserFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.api.IRecordWithMetadataParser;
import org.apache.asterix.external.api.IRecordWithPKDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.api.IStreamDataParserFactory;
import org.apache.asterix.external.dataflow.ChangeFeedDataFlowController;
import org.apache.asterix.external.dataflow.ChangeFeedWithMetaDataFlowController;
import org.apache.asterix.external.dataflow.FeedRecordDataFlowController;
import org.apache.asterix.external.dataflow.FeedStreamDataFlowController;
import org.apache.asterix.external.dataflow.FeedWithMetaDataFlowController;
import org.apache.asterix.external.dataflow.RecordDataFlowController;
import org.apache.asterix.external.dataflow.StreamDataFlowController;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.IFeedLogManager;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DataflowControllerProvider {
    private DataflowControllerProvider() {
    }

    public static IDataFlowController getDataflowController(ARecordType recordType, IHyracksTaskContext ctx, int partition, IExternalDataSourceFactory dataSourceFactory, IDataParserFactory dataParserFactory, Map<String, String> configuration, boolean isFeed, IFeedLogManager feedLogManager) throws HyracksDataException {
        IExternalDataRuntimeContext runtimeContext = dataSourceFactory.createExternalDataRuntimeContext(ctx, partition);
        try {
            switch (dataSourceFactory.getDataSourceType()) {
                case RECORDS: {
                    IRecordReaderFactory recordReaderFactory = (IRecordReaderFactory)dataSourceFactory;
                    IRecordReader recordReader = recordReaderFactory.createRecordReader(runtimeContext);
                    IRecordDataParserFactory recordParserFactory = (IRecordDataParserFactory)dataParserFactory;
                    IRecordDataParser dataParser = recordParserFactory.createRecordParser(runtimeContext);
                    if (isFeed) {
                        boolean isChangeFeed = ExternalDataUtils.isChangeFeed(configuration);
                        boolean isRecordWithMeta = ExternalDataUtils.isRecordWithMeta(configuration);
                        if (isRecordWithMeta) {
                            if (isChangeFeed) {
                                int numOfKeys = ExternalDataUtils.getNumberOfKeys(configuration);
                                return new ChangeFeedWithMetaDataFlowController(ctx, feedLogManager, numOfKeys + 2, (IRecordWithMetadataParser)dataParser, recordReader);
                            }
                            return new FeedWithMetaDataFlowController(ctx, feedLogManager, 2, (IRecordWithMetadataParser)dataParser, recordReader);
                        }
                        if (isChangeFeed) {
                            int numOfKeys = ExternalDataUtils.getNumberOfKeys(configuration);
                            return new ChangeFeedDataFlowController(ctx, feedLogManager, numOfKeys + 1, (IRecordWithPKDataParser)dataParser, recordReader);
                        }
                        return new FeedRecordDataFlowController(ctx, feedLogManager, 1, dataParser, recordReader);
                    }
                    return new RecordDataFlowController(ctx, dataParser, recordReader, 1);
                }
                case STREAM: {
                    IInputStreamFactory streamFactory = (IInputStreamFactory)dataSourceFactory;
                    AsterixInputStream stream = streamFactory.createInputStream(runtimeContext);
                    IStreamDataParserFactory streamParserFactory = (IStreamDataParserFactory)dataParserFactory;
                    IStreamDataParser streamParser = streamParserFactory.createInputStreamParser(runtimeContext);
                    streamParser.setInputStream(stream);
                    if (isFeed) {
                        return new FeedStreamDataFlowController(ctx, feedLogManager, streamParser, stream);
                    }
                    return new StreamDataFlowController(ctx, streamParser);
                }
            }
            throw new RuntimeDataException(ErrorCode.PROVIDER_DATAFLOW_CONTROLLER_UNKNOWN_DATA_SOURCE, new Serializable[]{dataSourceFactory.getDataSourceType()});
        }
        catch (IOException | AsterixException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

