/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.PythonTCPSocketProto;
import org.apache.asterix.external.library.AbstractLibrarySocketEvaluator;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.asterix.external.library.PythonLibraryEvaluatorId;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.ipc.impl.IPCSystem;

public class PythonLibraryTCPSocketEvaluator
extends AbstractLibrarySocketEvaluator {
    public static final String ENTRYPOINT = "entrypoint.py";
    public static final String SITE_PACKAGES = "site-packages";
    private Process p;
    private ILibraryManager libMgr;
    private File pythonHome;
    private ExternalFunctionResultRouter router;
    private IPCSystem ipcSys;
    private String sitePkgs;
    private List<String> pythonArgs;
    private Map<String, String> pythonEnv;

    public PythonLibraryTCPSocketEvaluator(JobId jobId, PythonLibraryEvaluatorId evaluatorId, ILibraryManager libMgr, File pythonHome, String sitePkgs, List<String> pythonArgs, Map<String, String> pythonEnv, ExternalFunctionResultRouter router, IPCSystem ipcSys, TaskAttemptId task, IWarningCollector warningCollector, SourceLocation sourceLoc) {
        super(jobId, evaluatorId, task, warningCollector, sourceLoc);
        this.libMgr = libMgr;
        this.pythonHome = pythonHome;
        this.sitePkgs = sitePkgs;
        this.pythonArgs = pythonArgs;
        this.pythonEnv = pythonEnv;
        this.router = router;
        this.ipcSys = ipcSys;
    }

    @Override
    public void start() throws IOException, AsterixException {
        PythonLibraryEvaluatorId fnId = (PythonLibraryEvaluatorId)this.id;
        PythonLibrary library = (PythonLibrary)this.libMgr.getLibrary(fnId.getLibraryNamespace(), fnId.getLibraryName());
        String wd = library.getFile().getAbsolutePath();
        int port = this.ipcSys.getSocketAddress().getPort();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.pythonHome.getAbsolutePath());
        args.addAll(this.pythonArgs);
        args.add(ENTRYPOINT);
        args.add(InetAddress.getLoopbackAddress().getHostAddress());
        args.add(Integer.toString(port));
        args.add(this.sitePkgs);
        ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
        pb.environment().putAll(this.pythonEnv);
        pb.directory(new File(wd));
        this.p = pb.start();
        this.proto = new PythonTCPSocketProto(this.p.getOutputStream(), this.router, this.p);
        this.proto.start();
        this.proto.helo();
    }

    public void deallocate() {
        if (this.p != null) {
            boolean dead = false;
            try {
                this.p.destroy();
                dead = this.p.waitFor(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!dead) {
                this.p.destroyForcibly();
            }
        }
        this.router.removeRoute(Long.valueOf(this.proto.getRouteId()));
    }

    static PythonLibraryTCPSocketEvaluator getInstance(IExternalFunctionInfo finfo, ILibraryManager libMgr, ExternalFunctionResultRouter router, IPCSystem ipcSys, File pythonHome, IHyracksTaskContext ctx, String sitePkgs, List<String> pythonArgs, Map<String, String> pythonEnv, IWarningCollector warningCollector, SourceLocation sourceLoc) throws IOException, AsterixException {
        PythonLibraryEvaluatorId evaluatorId = new PythonLibraryEvaluatorId(finfo.getLibraryNamespace(), finfo.getLibraryName(), Thread.currentThread());
        PythonLibraryTCPSocketEvaluator evaluator = (PythonLibraryTCPSocketEvaluator)ctx.getStateObject((Object)evaluatorId);
        if (evaluator == null) {
            evaluator = new PythonLibraryTCPSocketEvaluator(ctx.getJobletContext().getJobId(), evaluatorId, libMgr, pythonHome, sitePkgs, pythonArgs, pythonEnv, router, ipcSys, ctx.getTaskAttemptId(), warningCollector, sourceLoc);
            ctx.getJobletContext().registerDeallocatable((IDeallocatable)evaluator);
            evaluator.start();
            ctx.setStateObject((IStateObject)evaluator);
        }
        return evaluator;
    }
}

